/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.reactor.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpStatusClass;
import io.pivotal.UnknownSchedulerException;
import io.pivotal.scheduler.v1.SchedulerError;
import io.pivotal.scheduler.v1.SchedulerException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.cloudfoundry.reactor.HttpClientResponseWithConnection;
import org.cloudfoundry.reactor.util.ErrorPayloadMapper;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufFlux;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClientResponse;

public final class ErrorPayloadMappers {
    public static ErrorPayloadMapper scheduler(ObjectMapper objectMapper) {
        return inbound -> inbound.flatMap(ErrorPayloadMappers.mapToError((statusCode, payload) -> {
            Map map = (Map)objectMapper.readValue(payload, Map.class);
            String description = (String)map.get("description");
            List errors = ((List)map.get("errors")).stream().map(error -> SchedulerError.builder().resource((String)error.get("resource")).messages((Iterable)((List)error.get("messages"))).build()).collect(Collectors.toList());
            return new SchedulerException(statusCode, description, errors);
        }));
    }

    private static boolean isError(HttpClientResponse response) {
        HttpStatusClass statusClass = response.status().codeClass();
        return statusClass == HttpStatusClass.CLIENT_ERROR || statusClass == HttpStatusClass.SERVER_ERROR;
    }

    private static Function<HttpClientResponseWithConnection, Mono<HttpClientResponseWithConnection>> mapToError(ExceptionGenerator exceptionGenerator) {
        return response -> {
            if (!ErrorPayloadMappers.isError(response.getResponse())) {
                return Mono.just((Object)response);
            }
            Connection connection = response.getConnection();
            ByteBufFlux body = ByteBufFlux.fromInbound((Publisher)connection.inbound().receive().doFinally(signalType -> connection.dispose()));
            return body.aggregate().asString().switchIfEmpty(Mono.error((Throwable)new UnknownSchedulerException(Integer.valueOf(response.getResponse().status().code())))).flatMap(payload -> {
                try {
                    return Mono.error((Throwable)exceptionGenerator.apply(response.getResponse().status().code(), (String)payload));
                }
                catch (Exception e) {
                    return Mono.error((Throwable)new UnknownSchedulerException(Integer.valueOf(response.getResponse().status().code()), payload));
                }
            });
        };
    }

    @FunctionalInterface
    private static interface ExceptionGenerator {
        public RuntimeException apply(Integer var1, String var2) throws Exception;
    }
}

