/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.reactor.util;

import io.pivotal.scheduler.v1.PaginatedResponse;
import java.util.Optional;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PaginationUtils {
    private PaginationUtils() {
    }

    public static <T, U extends PaginatedResponse<T>> Flux<T> requestResources(Function<Integer, Mono<U>> pageSupplier) {
        return pageSupplier.apply(1).flatMapMany(PaginationUtils.requestAdditionalPages(pageSupplier)).flatMapIterable(PaginatedResponse::getResources);
    }

    private static <T> Function<T, Flux<T>> requestAdditionalPages(Function<Integer, Mono<T>> pageSupplier, Function<T, Integer> totalPagesSupplier) {
        return response -> {
            Integer totalPages = Optional.ofNullable((Integer)totalPagesSupplier.apply(response)).orElse(1);
            return Flux.range((int)2, (int)(totalPages - 1)).flatMap(pageSupplier).startWith(new Object[]{response}).buffer().flatMapIterable(d -> d);
        };
    }

    private static <T extends PaginatedResponse<?>> Function<T, Flux<T>> requestAdditionalPages(Function<Integer, Mono<T>> pageSupplier) {
        return PaginationUtils.requestAdditionalPages(pageSupplier, response -> response.getPagination().getTotalPages());
    }
}

