/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.scheduler.v1;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.pivotal.scheduler.v1._SchedulerError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="_SchedulerError", generator="Immutables")
public final class SchedulerError
extends _SchedulerError {
    private final List<String> messages;
    private final String resource;

    private SchedulerError(Builder builder) {
        this.messages = SchedulerError.createUnmodifiableList(true, builder.messages);
        this.resource = builder.resource;
    }

    @Override
    @JsonProperty(value="messages")
    public List<String> getMessages() {
        return this.messages;
    }

    @Override
    @JsonProperty(value="resource")
    public String getResource() {
        return this.resource;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SchedulerError && this.equalTo((SchedulerError)another);
    }

    private boolean equalTo(SchedulerError another) {
        return this.messages.equals(another.messages) && this.resource.equals(another.resource);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.messages.hashCode();
        h += (h << 5) + this.resource.hashCode();
        return h;
    }

    public String toString() {
        return "SchedulerError{messages=" + this.messages + ", resource=" + this.resource + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SchedulerError fromJson(Json json) {
        Builder builder = SchedulerError.builder();
        if (json.messages != null) {
            builder.addAllMessages(json.messages);
        }
        if (json.resource != null) {
            builder.resource(json.resource);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_SchedulerError", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_RESOURCE = 1L;
        private long initBits = 1L;
        private List<String> messages = new ArrayList<String>();
        private String resource;

        private Builder() {
        }

        public final Builder from(SchedulerError instance) {
            return this.from((_SchedulerError)instance);
        }

        final Builder from(_SchedulerError instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllMessages(instance.getMessages());
            this.resource(instance.getResource());
            return this;
        }

        public final Builder message(String element) {
            this.messages.add(Objects.requireNonNull(element, "messages element"));
            return this;
        }

        public final Builder messages(String ... elements) {
            for (String element : elements) {
                this.messages.add(Objects.requireNonNull(element, "messages element"));
            }
            return this;
        }

        @JsonProperty(value="messages")
        public final Builder messages(Iterable<String> elements) {
            this.messages.clear();
            return this.addAllMessages(elements);
        }

        public final Builder addAllMessages(Iterable<String> elements) {
            for (String element : elements) {
                this.messages.add(Objects.requireNonNull(element, "messages element"));
            }
            return this;
        }

        @JsonProperty(value="resource")
        public final Builder resource(String resource) {
            this.resource = Objects.requireNonNull(resource, "resource");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public SchedulerError build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new SchedulerError(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("resource");
            }
            return "Cannot build SchedulerError, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_SchedulerError", generator="Immutables")
    static final class Json
    extends _SchedulerError {
        List<String> messages = Collections.emptyList();
        String resource;

        Json() {
        }

        @JsonProperty(value="messages")
        public void setMessages(List<String> messages) {
            this.messages = messages;
        }

        @JsonProperty(value="resource")
        public void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public List<String> getMessages() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getResource() {
            throw new UnsupportedOperationException();
        }
    }
}

