/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.scheduler.v1.calls;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.pivotal.scheduler.v1.calls._CreateCallRequest;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

@Generated(from="_CreateCallRequest", generator="Immutables")
public final class CreateCallRequest
extends _CreateCallRequest {
    @Nullable
    private final String applicationId;
    private final String authorizationHeader;
    private final String name;
    private final String url;

    private CreateCallRequest(Builder builder) {
        this.applicationId = builder.applicationId;
        this.authorizationHeader = builder.authorizationHeader;
        this.name = builder.name;
        this.url = builder.url;
    }

    @Override
    @JsonIgnore
    @Nullable
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    @JsonProperty(value="auth_header")
    public String getAuthorizationHeader() {
        return this.authorizationHeader;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateCallRequest && this.equalTo((CreateCallRequest)another);
    }

    private boolean equalTo(CreateCallRequest another) {
        return Objects.equals(this.applicationId, another.applicationId) && this.authorizationHeader.equals(another.authorizationHeader) && this.name.equals(another.name) && this.url.equals(another.url);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.applicationId);
        h += (h << 5) + this.authorizationHeader.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.url.hashCode();
        return h;
    }

    public String toString() {
        return "CreateCallRequest{applicationId=" + this.applicationId + ", authorizationHeader=" + this.authorizationHeader + ", name=" + this.name + ", url=" + this.url + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CreateCallRequest fromJson(Json json) {
        Builder builder = CreateCallRequest.builder();
        if (json.applicationId != null) {
            builder.applicationId(json.applicationId);
        }
        if (json.authorizationHeader != null) {
            builder.authorizationHeader(json.authorizationHeader);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_CreateCallRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_AUTHORIZATION_HEADER = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_URL = 4L;
        private long initBits = 7L;
        private String applicationId;
        private String authorizationHeader;
        private String name;
        private String url;

        private Builder() {
        }

        public final Builder from(CreateCallRequest instance) {
            return this.from((_CreateCallRequest)instance);
        }

        final Builder from(_CreateCallRequest instance) {
            Objects.requireNonNull(instance, "instance");
            String applicationIdValue = instance.getApplicationId();
            if (applicationIdValue != null) {
                this.applicationId(applicationIdValue);
            }
            this.authorizationHeader(instance.getAuthorizationHeader());
            this.name(instance.getName());
            this.url(instance.getUrl());
            return this;
        }

        public final Builder applicationId(@Nullable String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Builder authorizationHeader(String authorizationHeader) {
            this.authorizationHeader = Objects.requireNonNull(authorizationHeader, "authorizationHeader");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public CreateCallRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateCallRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("authorizationHeader");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("url");
            }
            return "Cannot build CreateCallRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_CreateCallRequest", generator="Immutables")
    static final class Json
    extends _CreateCallRequest {
        String applicationId;
        String authorizationHeader;
        String name;
        String url;

        Json() {
        }

        @JsonIgnore
        public void setApplicationId(@Nullable String applicationId) {
            this.applicationId = applicationId;
        }

        @JsonProperty(value="auth_header")
        public void setAuthorizationHeader(String authorizationHeader) {
            this.authorizationHeader = authorizationHeader;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="url")
        public void setUrl(String url) {
            this.url = url;
        }

        @Override
        public String getApplicationId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAuthorizationHeader() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

