/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.scheduler.v1.calls;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.pivotal.scheduler.v1.calls._ScheduleCallRequest;
import io.pivotal.scheduler.v1.schedules.ExpressionType;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="_ScheduleCallRequest", generator="Immutables")
public final class ScheduleCallRequest
extends _ScheduleCallRequest {
    private final String callId;
    private final Boolean enabled;
    private final String expression;
    private final ExpressionType expressionType;

    private ScheduleCallRequest(Builder builder) {
        this.callId = builder.callId;
        this.enabled = builder.enabled;
        this.expression = builder.expression;
        this.expressionType = builder.expressionType;
    }

    @Override
    @JsonProperty(value="callId")
    @JsonIgnore
    public String getCallId() {
        return this.callId;
    }

    @Override
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="expression")
    public String getExpression() {
        return this.expression;
    }

    @Override
    @JsonProperty(value="expression_type")
    public ExpressionType getExpressionType() {
        return this.expressionType;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ScheduleCallRequest && this.equalTo((ScheduleCallRequest)another);
    }

    private boolean equalTo(ScheduleCallRequest another) {
        return this.callId.equals(another.callId) && this.enabled.equals(another.enabled) && this.expression.equals(another.expression) && this.expressionType.equals((Object)another.expressionType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.callId.hashCode();
        h += (h << 5) + this.enabled.hashCode();
        h += (h << 5) + this.expression.hashCode();
        h += (h << 5) + this.expressionType.hashCode();
        return h;
    }

    public String toString() {
        return "ScheduleCallRequest{callId=" + this.callId + ", enabled=" + this.enabled + ", expression=" + this.expression + ", expressionType=" + (Object)((Object)this.expressionType) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ScheduleCallRequest fromJson(Json json) {
        Builder builder = ScheduleCallRequest.builder();
        if (json.callId != null) {
            builder.callId(json.callId);
        }
        if (json.enabled != null) {
            builder.enabled(json.enabled);
        }
        if (json.expression != null) {
            builder.expression(json.expression);
        }
        if (json.expressionType != null) {
            builder.expressionType(json.expressionType);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_ScheduleCallRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CALL_ID = 1L;
        private static final long INIT_BIT_ENABLED = 2L;
        private static final long INIT_BIT_EXPRESSION = 4L;
        private static final long INIT_BIT_EXPRESSION_TYPE = 8L;
        private long initBits = 15L;
        private String callId;
        private Boolean enabled;
        private String expression;
        private ExpressionType expressionType;

        private Builder() {
        }

        public final Builder from(ScheduleCallRequest instance) {
            return this.from((_ScheduleCallRequest)instance);
        }

        final Builder from(_ScheduleCallRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.callId(instance.getCallId());
            this.enabled(instance.getEnabled());
            this.expression(instance.getExpression());
            this.expressionType(instance.getExpressionType());
            return this;
        }

        public final Builder callId(String callId) {
            this.callId = Objects.requireNonNull(callId, "callId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder enabled(Boolean enabled) {
            this.enabled = Objects.requireNonNull(enabled, "enabled");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder expression(String expression) {
            this.expression = Objects.requireNonNull(expression, "expression");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder expressionType(ExpressionType expressionType) {
            this.expressionType = Objects.requireNonNull(expressionType, "expressionType");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ScheduleCallRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ScheduleCallRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("callId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("enabled");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("expression");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("expressionType");
            }
            return "Cannot build ScheduleCallRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_ScheduleCallRequest", generator="Immutables")
    static final class Json
    extends _ScheduleCallRequest {
        String callId;
        Boolean enabled;
        String expression;
        ExpressionType expressionType;

        Json() {
        }

        @JsonProperty(value="callId")
        @JsonIgnore
        public void setCallId(String callId) {
            this.callId = callId;
        }

        @JsonProperty(value="enabled")
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @JsonProperty(value="expression")
        public void setExpression(String expression) {
            this.expression = expression;
        }

        @JsonProperty(value="expression_type")
        public void setExpressionType(ExpressionType expressionType) {
            this.expressionType = expressionType;
        }

        @Override
        public String getCallId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getEnabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getExpression() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ExpressionType getExpressionType() {
            throw new UnsupportedOperationException();
        }
    }
}

