/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.scheduler.v1.jobs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.pivotal.scheduler.v1.jobs._CreateJobRequest;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="_CreateJobRequest", generator="Immutables")
public final class CreateJobRequest
extends _CreateJobRequest {
    private final String applicationId;
    private final String command;
    private final String name;

    private CreateJobRequest(Builder builder) {
        this.applicationId = builder.applicationId;
        this.command = builder.command;
        this.name = builder.name;
    }

    @Override
    @JsonIgnore
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    @JsonProperty(value="command")
    public String getCommand() {
        return this.command;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateJobRequest && this.equalTo((CreateJobRequest)another);
    }

    private boolean equalTo(CreateJobRequest another) {
        return this.applicationId.equals(another.applicationId) && this.command.equals(another.command) && this.name.equals(another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.applicationId.hashCode();
        h += (h << 5) + this.command.hashCode();
        h += (h << 5) + this.name.hashCode();
        return h;
    }

    public String toString() {
        return "CreateJobRequest{applicationId=" + this.applicationId + ", command=" + this.command + ", name=" + this.name + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CreateJobRequest fromJson(Json json) {
        Builder builder = CreateJobRequest.builder();
        if (json.applicationId != null) {
            builder.applicationId(json.applicationId);
        }
        if (json.command != null) {
            builder.command(json.command);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_CreateJobRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_ID = 1L;
        private static final long INIT_BIT_COMMAND = 2L;
        private static final long INIT_BIT_NAME = 4L;
        private long initBits = 7L;
        private String applicationId;
        private String command;
        private String name;

        private Builder() {
        }

        public final Builder from(CreateJobRequest instance) {
            return this.from((_CreateJobRequest)instance);
        }

        final Builder from(_CreateJobRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.applicationId(instance.getApplicationId());
            this.command(instance.getCommand());
            this.name(instance.getName());
            return this;
        }

        public final Builder applicationId(String applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder command(String command) {
            this.command = Objects.requireNonNull(command, "command");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public CreateJobRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateJobRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("command");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build CreateJobRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_CreateJobRequest", generator="Immutables")
    static final class Json
    extends _CreateJobRequest {
        String applicationId;
        String command;
        String name;

        Json() {
        }

        @JsonIgnore
        public void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @JsonProperty(value="command")
        public void setCommand(String command) {
            this.command = command;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public String getApplicationId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCommand() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }
    }
}

