/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.scheduler.v1.jobs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.pivotal.scheduler.v1.Pagination;
import io.pivotal.scheduler.v1.jobs.Job;
import io.pivotal.scheduler.v1.jobs._ListJobsResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

@Generated(from="_ListJobsResponse", generator="Immutables")
public final class ListJobsResponse
extends _ListJobsResponse {
    @Nullable
    private final Pagination pagination;
    @Nullable
    private final List<Job> resources;

    private ListJobsResponse(Builder builder) {
        this.pagination = builder.pagination;
        this.resources = builder.resources == null ? null : ListJobsResponse.createUnmodifiableList(true, builder.resources);
    }

    @Override
    @JsonProperty(value="pagination")
    @Nullable
    public Pagination getPagination() {
        return this.pagination;
    }

    @Override
    @JsonProperty(value="resources")
    @Nullable
    public List<Job> getResources() {
        return this.resources;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListJobsResponse && this.equalTo((ListJobsResponse)another);
    }

    private boolean equalTo(ListJobsResponse another) {
        return Objects.equals(this.pagination, another.pagination) && Objects.equals(this.resources, another.resources);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.pagination);
        h += (h << 5) + Objects.hashCode(this.resources);
        return h;
    }

    public String toString() {
        return "ListJobsResponse{pagination=" + this.pagination + ", resources=" + this.resources + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ListJobsResponse fromJson(Json json) {
        Builder builder = ListJobsResponse.builder();
        if (json.pagination != null) {
            builder.pagination(json.pagination);
        }
        if (json.resources != null) {
            builder.addAllResources(json.resources);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListJobsResponse", generator="Immutables")
    public static final class Builder {
        private Pagination pagination;
        private List<Job> resources = null;

        private Builder() {
        }

        public final Builder from(ListJobsResponse instance) {
            return this.from((_ListJobsResponse)instance);
        }

        final Builder from(_ListJobsResponse instance) {
            List resourcesValue;
            Objects.requireNonNull(instance, "instance");
            Pagination paginationValue = instance.getPagination();
            if (paginationValue != null) {
                this.pagination(paginationValue);
            }
            if ((resourcesValue = instance.getResources()) != null) {
                this.addAllResources(resourcesValue);
            }
            return this;
        }

        @JsonProperty(value="pagination")
        public final Builder pagination(@Nullable Pagination pagination) {
            this.pagination = pagination;
            return this;
        }

        public final Builder resource(Job element) {
            if (this.resources == null) {
                this.resources = new ArrayList<Job>();
            }
            this.resources.add(Objects.requireNonNull(element, "resources element"));
            return this;
        }

        public final Builder resources(Job ... elements) {
            if (this.resources == null) {
                this.resources = new ArrayList<Job>();
            }
            for (Job element : elements) {
                this.resources.add(Objects.requireNonNull(element, "resources element"));
            }
            return this;
        }

        @JsonProperty(value="resources")
        public final Builder resources(@Nullable Iterable<? extends Job> elements) {
            if (elements == null) {
                this.resources = null;
                return this;
            }
            this.resources = new ArrayList<Job>();
            return this.addAllResources(elements);
        }

        public final Builder addAllResources(Iterable<? extends Job> elements) {
            Objects.requireNonNull(elements, "resources element");
            if (this.resources == null) {
                this.resources = new ArrayList<Job>();
            }
            for (Job job : elements) {
                this.resources.add(Objects.requireNonNull(job, "resources element"));
            }
            return this;
        }

        public ListJobsResponse build() {
            return new ListJobsResponse(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_ListJobsResponse", generator="Immutables")
    static final class Json
    extends _ListJobsResponse {
        Pagination pagination;
        List<Job> resources = null;

        Json() {
        }

        @JsonProperty(value="pagination")
        public void setPagination(@Nullable Pagination pagination) {
            this.pagination = pagination;
        }

        @JsonProperty(value="resources")
        public void setResources(@Nullable List<Job> resources) {
            this.resources = resources;
        }

        @Override
        public Pagination getPagination() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Job> getResources() {
            throw new UnsupportedOperationException();
        }
    }
}

