/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.springcloud.ssl;

import io.pivotal.springcloud.ssl.SslCertificateTruster;
import java.net.MalformedURLException;
import java.net.URL;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;

public class CloudFoundryCertificateTruster
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final CloudFoundryCertificateTruster instance = new CloudFoundryCertificateTruster();
    private EnvironmentVariableResolver env = new EnvironmentVariableResolver();
    private SslCertificateTruster sslCertificateTruster = SslCertificateTruster.instance;

    public static void trustCertificates() {
        instance.trustCertificatesInternal();
    }

    void trustCertificatesInternal() {
        String trustCerts;
        String cfTarget = this.env.getValue("CF_TARGET");
        if (cfTarget != null) {
            try {
                URL cfTargetUrl = new URL(cfTarget);
                String host = cfTargetUrl.getHost();
                if ("https".equals(cfTargetUrl.getProtocol()) && host != null) {
                    int httpsPort = cfTargetUrl.getPort() > 0 ? cfTargetUrl.getPort() : 443;
                    try {
                        this.sslCertificateTruster.trustCertificateInternal(host, httpsPort, 5000);
                    }
                    catch (Exception e) {
                        System.err.println("trusting certificate at " + host + ":" + httpsPort + " failed due to " + e);
                        e.printStackTrace();
                    }
                }
            }
            catch (MalformedURLException e1) {
                System.err.println("Cannot parse CF_TARGET '" + cfTarget + "' as a URL");
            }
        }
        if ((trustCerts = this.env.getValue("TRUST_CERTS")) != null) {
            for (String hostAndPort : trustCerts.split(",")) {
                String[] parts = hostAndPort.split(":");
                String host = parts[0];
                int port = 443;
                try {
                    port = Integer.parseInt(parts[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (host == null || host.length() <= 0 || port <= 0 || port >= 65536) continue;
                try {
                    this.sslCertificateTruster.trustCertificateInternal(host, port, 5000);
                }
                catch (Exception e) {
                    System.err.println("trusting certificate at " + host + ":" + port + " failed due to " + e);
                    e.printStackTrace();
                }
            }
        }
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
    }

    static {
        CloudFoundryCertificateTruster.trustCertificates();
    }

    static class EnvironmentVariableResolver {
        EnvironmentVariableResolver() {
        }

        String getValue(String key) {
            return System.getenv(key);
        }
    }
}

