/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.springcloud.ssl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SslCertificateTruster {
    public static final String JAVAX_NET_SSL_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    public static final String JAVAX_NET_SSL_TRUST_STORE = "javax.net.ssl.trustStore";
    private final ExecutorService executor = Executors.newFixedThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "SSLCertificateTruster:downloader");
        }
    });
    static final SslCertificateTruster instance = new SslCertificateTruster();

    private SslCertificateTruster() {
    }

    public static X509Certificate[] getUntrustedCertificate(String host, int port, int timeout) throws Exception {
        return instance.getUntrustedCertificateInternal(host, port, timeout);
    }

    X509Certificate[] getUntrustedCertificateInternal(final String host, final int port, int timeout) throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        X509TrustManager defaultTrustManager = SslCertificateTruster.getDefaultTrustManager();
        CertificateCollectingTrustManager collector = new CertificateCollectingTrustManager(defaultTrustManager);
        context.init(null, new TrustManager[]{collector}, null);
        final SSLSocketFactory factory = context.getSocketFactory();
        Future<?> task = this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    SSLSocket socket = (SSLSocket)factory.createSocket(host, port);
                    socket.startHandshake();
                    socket.close();
                }
                catch (Exception e) {
                    System.err.println("Error downloading certificate " + host + ":" + port + "," + e);
                }
            }
        });
        try {
            task.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            task.cancel(true);
            throw e;
        }
        X509Certificate[] chain = collector.getCollectedCertificateChain();
        if (chain == null) {
            throw new CertificateException("Could not obtain server certificate chain");
        }
        if (collector.isTrusted()) {
            return null;
        }
        return chain;
    }

    public static void trustCertificate(String host, int port, int timeout) throws Exception {
        instance.trustCertificateInternal(host, port, timeout);
    }

    void trustCertificateInternal(String host, int port, int timeout) throws Exception {
        X509Certificate[] untrusted = SslCertificateTruster.getUntrustedCertificate(host, port, timeout);
        if (untrusted != null) {
            SslCertificateTruster.appendToTruststore(untrusted);
        }
    }

    public static void appendToTruststore(X509Certificate[] chain) throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException, FileNotFoundException {
        instance.appendToTruststoreInternal(chain);
    }

    void appendToTruststoreInternal(X509Certificate[] chain) throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException, FileNotFoundException {
        X509TrustManager defaultTrustManager = SslCertificateTruster.getDefaultTrustManager();
        X509Certificate[] cacerts = defaultTrustManager.getAcceptedIssuers();
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(null);
        int count = 0;
        for (X509Certificate cert : cacerts) {
            trustStore.setCertificateEntry("" + count++, cert);
        }
        for (X509Certificate cert : chain) {
            trustStore.setCertificateEntry("" + count++, cert);
        }
        String password = UUID.randomUUID().toString();
        File trustStoreOutputFile = File.createTempFile("truststore", null);
        trustStoreOutputFile.deleteOnExit();
        trustStore.store(new FileOutputStream(trustStoreOutputFile), password.toCharArray());
        System.setProperty(JAVAX_NET_SSL_TRUST_STORE, trustStoreOutputFile.getAbsolutePath());
        System.setProperty(JAVAX_NET_SSL_TRUST_STORE_PASSWORD, password);
    }

    private static X509TrustManager getDefaultTrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        X509TrustManager defaultTrustManager = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
        return defaultTrustManager;
    }

    private static class CertificateCollectingTrustManager
    implements X509TrustManager {
        private final X509TrustManager delegate;
        private X509Certificate[] collected;
        private Boolean trusted;

        CertificateCollectingTrustManager(X509TrustManager delegate) {
            this.delegate = delegate;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.delegate.getAcceptedIssuers();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (this.collected != null) {
                throw new IllegalStateException("A certificate chain has already been collected.");
            }
            this.collected = chain;
            try {
                this.delegate.checkClientTrusted(chain, authType);
                this.trusted = true;
            }
            catch (CertificateException e) {
                this.trusted = false;
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (this.collected != null) {
                throw new IllegalStateException("A certificate chain has already been collected.");
            }
            this.collected = chain;
            try {
                this.delegate.checkServerTrusted(chain, authType);
                this.trusted = true;
            }
            catch (CertificateException e) {
                this.trusted = false;
            }
        }

        private boolean isTrusted() {
            if (this.trusted == null) {
                throw new IllegalStateException("No certificates have been collected yet");
            }
            return this.trusted;
        }

        private X509Certificate[] getCollectedCertificateChain() {
            return this.collected;
        }
    }
}

