/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.cloudfoundry;

import io.pivotal.spring.cloud.service.common.ConfigServerServiceInfo;
import java.util.Map;
import org.springframework.cloud.cloudfoundry.CloudFoundryServiceInfoCreator;
import org.springframework.cloud.cloudfoundry.Tags;

public class ConfigServerServiceInfoCreator
extends CloudFoundryServiceInfoCreator<ConfigServerServiceInfo> {
    private static final String CREDENTIALS_ID_KEY = "name";
    private static final String CONFIG_SERVER_SERVICE_TAG_NAME = "configuration";

    public ConfigServerServiceInfoCreator() {
        super(new Tags(new String[]{CONFIG_SERVER_SERVICE_TAG_NAME}), new String[0]);
    }

    public ConfigServerServiceInfo createServiceInfo(Map<String, Object> serviceData) {
        String id = (String)serviceData.get(CREDENTIALS_ID_KEY);
        String uri = this.getUriFromCredentials(this.getCredentials(serviceData));
        Map credentials = this.getCredentials(serviceData);
        String clientId = this.getStringFromCredentials(credentials, new String[]{"client_id"});
        String clientSecret = this.getStringFromCredentials(credentials, new String[]{"client_secret"});
        String accessTokenUri = this.getStringFromCredentials(credentials, new String[]{"access_token_uri"});
        return new ConfigServerServiceInfo(id, uri, clientId, clientSecret, accessTokenUri);
    }
}

