/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.cloudfoundry;

import io.pivotal.spring.cloud.service.common.EurekaServiceInfo;
import java.util.Map;
import org.springframework.cloud.cloudfoundry.CloudFoundryServiceInfoCreator;
import org.springframework.cloud.cloudfoundry.Tags;

public class EurekaServiceInfoCreator
extends CloudFoundryServiceInfoCreator<EurekaServiceInfo> {
    private static final String CREDENTIALS_ID_KEY = "name";
    private static final String EUREKA_SERVICE_TAG_NAME = "eureka";

    public EurekaServiceInfoCreator() {
        super(new Tags(new String[]{EUREKA_SERVICE_TAG_NAME}), new String[0]);
    }

    public EurekaServiceInfo createServiceInfo(Map<String, Object> serviceData) {
        String id = (String)serviceData.get(CREDENTIALS_ID_KEY);
        Map credentials = this.getCredentials(serviceData);
        String uri = this.getUriFromCredentials(credentials);
        String clientId = this.getStringFromCredentials(credentials, new String[]{"client_id"});
        String clientSecret = this.getStringFromCredentials(credentials, new String[]{"client_secret"});
        String accessTokenUri = this.getStringFromCredentials(credentials, new String[]{"access_token_uri"});
        return new EurekaServiceInfo(id, uri, clientId, clientSecret, accessTokenUri);
    }
}

