/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.cloudfoundry;

import io.pivotal.spring.cloud.service.common.HystrixAmqpServiceInfo;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.cloudfoundry.CloudFoundryServiceInfoCreator;
import org.springframework.cloud.cloudfoundry.Tags;

public class HystrixAmqpServiceInfoCreator
extends CloudFoundryServiceInfoCreator<HystrixAmqpServiceInfo> {
    private static final String TAG_NAME = "hystrix-amqp";
    private static final String CREDENTIALS_ID_KEY = "name";
    private static final String URIS_ID_KEY = "uris";
    private static final String SSL_ID_KEY = "ssl";
    public static final String AMQP_CREDENTIALS_KEY = "amqp";

    public HystrixAmqpServiceInfoCreator() {
        super(new Tags(new String[]{TAG_NAME}), new String[0]);
    }

    public boolean accept(Map<String, Object> serviceData) {
        Map credentials = this.getCredentials(serviceData);
        return super.accept(serviceData) && credentials.containsKey(AMQP_CREDENTIALS_KEY);
    }

    public HystrixAmqpServiceInfo createServiceInfo(Map<String, Object> serviceData) {
        String id = (String)serviceData.get(CREDENTIALS_ID_KEY);
        Map credentials = this.getCredentials(serviceData);
        Map amqpCredentials = (Map)credentials.get(AMQP_CREDENTIALS_KEY);
        String uri = this.getUriFromCredentials(amqpCredentials);
        List uris = (List)amqpCredentials.get(URIS_ID_KEY);
        boolean sslEnabled = Boolean.valueOf(amqpCredentials.get(SSL_ID_KEY).toString());
        return new HystrixAmqpServiceInfo(id, uri, uris, sslEnabled);
    }
}

