/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.config.client;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfEnv;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.spring.cloud.config.client.OAuth2AuthorizedClientHttpRequestInterceptor;
import java.util.List;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.util.ClassUtils;
import org.springframework.web.client.RestTemplate;

public class ConfigClientOAuth2BootstrapRegistryInitializer
implements BootstrapRegistryInitializer {
    private static final boolean CONFIG_CLIENT_IS_PRESENT = ClassUtils.isPresent((String)"org.springframework.cloud.config.client.ConfigServerConfigDataLoader", null);
    private static final boolean OAUTH2_CLIENT_IS_PRESENT = ClassUtils.isPresent((String)"org.springframework.security.oauth2.client.registration.ClientRegistration", null);
    private static final boolean JAVA_CFENV_IS_PRESENT = ClassUtils.isPresent((String)"io.pivotal.cfenv.core.CfEnv", null);

    public void initialize(BootstrapRegistry registry) {
        if (!(CONFIG_CLIENT_IS_PRESENT && OAUTH2_CLIENT_IS_PRESENT && JAVA_CFENV_IS_PRESENT)) {
            return;
        }
        CfEnv cfEnv = new CfEnv();
        List configServices = cfEnv.findServicesByTag(new String[]{"configuration"});
        if (configServices.size() != 1) {
            return;
        }
        CfCredentials credentials = ((CfService)configServices.stream().findFirst().get()).getCredentials();
        registry.register(RestTemplate.class, context -> {
            String clientId = credentials.getString(new String[]{"client_id"});
            String clientSecret = credentials.getString(new String[]{"client_secret"});
            String accessTokenUri = credentials.getString(new String[]{"access_token_uri"});
            RestTemplate restTemplate = new RestTemplate();
            ClientRegistration clientRegistration = ClientRegistration.withRegistrationId((String)"config-client").clientId(clientId).clientSecret(clientSecret).tokenUri(accessTokenUri).authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).build();
            restTemplate.getInterceptors().add(new OAuth2AuthorizedClientHttpRequestInterceptor(clientRegistration));
            return restTemplate;
        });
    }
}

