/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.config.client;

import io.pivotal.spring.cloud.config.client.ConfigClientOAuth2Properties;
import io.pivotal.spring.cloud.config.client.ConfigResourceClient;
import io.pivotal.spring.cloud.config.client.OAuth2AuthorizedClientHttpRequestInterceptor;
import io.pivotal.spring.cloud.config.client.OAuth2ConfigResourceClient;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.client.ConfigClientAutoConfiguration;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.web.client.RestTemplate;

@AutoConfiguration(after={ConfigClientAutoConfiguration.class})
@ConditionalOnClass(value={ConfigClientProperties.class})
@EnableConfigurationProperties(value={ConfigClientOAuth2Properties.class})
public class ConfigResourceClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ConfigResourceClient.class})
    @ConditionalOnProperty(prefix="spring.cloud.config.client.oauth2", name={"client-id", "client-secret", "access-token-uri"})
    public ConfigResourceClient configResourceClient(ConfigClientProperties configClientProperties, ConfigClientOAuth2Properties configClientOAuth2Properties) {
        ClientRegistration clientRegistration = ClientRegistration.withRegistrationId((String)"config-client").clientId(configClientOAuth2Properties.getClientId()).clientSecret(configClientOAuth2Properties.getClientSecret()).tokenUri(configClientOAuth2Properties.getAccessTokenUri()).authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).build();
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getInterceptors().add(new OAuth2AuthorizedClientHttpRequestInterceptor(clientRegistration));
        return new OAuth2ConfigResourceClient(restTemplate, configClientProperties);
    }
}

