/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.config.client;

import io.pivotal.spring.cloud.config.client.ConfigClientOAuth2Properties;
import io.pivotal.spring.cloud.config.client.OAuth2AuthorizedClientHttpRequestInterceptor;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.context.config.Profiles;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.cloud.config.client.ConfigClientRequestTemplateFactory;
import org.springframework.cloud.config.client.ConfigServerConfigDataResource;
import org.springframework.core.Ordered;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.web.client.RestTemplate;

public class OAuth2ConfigDataLocationResolver
implements ConfigDataLocationResolver<ConfigServerConfigDataResource>,
Ordered {
    private final Log log;

    public OAuth2ConfigDataLocationResolver(DeferredLogFactory factory) {
        this.log = factory.getLog(OAuth2ConfigDataLocationResolver.class);
    }

    public boolean isResolvable(ConfigDataLocationResolverContext resolverContext, ConfigDataLocation location) {
        if (!location.hasPrefix("configserver:")) {
            return false;
        }
        Binder binder = resolverContext.getBinder();
        Boolean isConfigEnabled = (Boolean)binder.bind("spring.cloud.config.enabled", Boolean.class).orElse((Object)true);
        if (!isConfigEnabled.booleanValue()) {
            return false;
        }
        ConfigurableBootstrapContext bootstrapContext = resolverContext.getBootstrapContext();
        ConfigClientOAuth2Properties oAuth2Properties = (ConfigClientOAuth2Properties)binder.bind("spring.cloud.config.client.oauth2", ConfigClientOAuth2Properties.class).orElse(null);
        if (oAuth2Properties != null) {
            bootstrapContext.registerIfAbsent(ConfigClientRequestTemplateFactory.class, context -> new OAuth2ConfigClientRequestTemplateFactory(this.log, (ConfigClientProperties)context.get(ConfigClientProperties.class), oAuth2Properties));
        } else {
            this.log.warn((Object)"Config Client oauth2 properties are missing. Skipping the auth interceptor configuration");
            bootstrapContext.registerIfAbsent(ConfigClientRequestTemplateFactory.class, context -> new ConfigClientRequestTemplateFactory(this.log, (ConfigClientProperties)context.get(ConfigClientProperties.class)));
        }
        bootstrapContext.addCloseListener(event -> event.getApplicationContext().getBeanFactory().registerSingleton("configClientRestTemplate", event.getBootstrapContext().get(RestTemplate.class)));
        return false;
    }

    public List<ConfigServerConfigDataResource> resolve(ConfigDataLocationResolverContext context, ConfigDataLocation location) throws ConfigDataLocationNotFoundException, ConfigDataResourceNotFoundException {
        throw new IllegalStateException("Unexpected call. This resolver should not resolve any location");
    }

    public List<ConfigServerConfigDataResource> resolveProfileSpecific(ConfigDataLocationResolverContext context, ConfigDataLocation location, Profiles profiles) throws ConfigDataLocationNotFoundException {
        throw new IllegalStateException("Unexpected call. This resolver should not resolve any location");
    }

    public int getOrder() {
        return -2;
    }

    private static class OAuth2ConfigClientRequestTemplateFactory
    extends ConfigClientRequestTemplateFactory {
        private final ClientRegistration clientRegistration;

        public OAuth2ConfigClientRequestTemplateFactory(Log log, ConfigClientProperties clientProperties, ConfigClientOAuth2Properties oAuth2Properties) {
            super(log, clientProperties);
            this.clientRegistration = ClientRegistration.withRegistrationId((String)"config-client").clientId(oAuth2Properties.getClientId()).clientSecret(oAuth2Properties.getClientSecret()).tokenUri(oAuth2Properties.getAccessTokenUri()).scope(oAuth2Properties.getScope()).authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).build();
        }

        public RestTemplate create() {
            RestTemplate restTemplate = super.create();
            restTemplate.getInterceptors().add(new OAuth2AuthorizedClientHttpRequestInterceptor(this.clientRegistration));
            return restTemplate;
        }
    }
}

