/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.service.registry;

import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClientConfig;
import io.pivotal.spring.cloud.service.registry.EurekaClientOAuth2Properties;
import io.pivotal.spring.cloud.service.registry.OAuth2DiscoveryClientOptionalArgs;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.netflix.eureka.EurekaClientAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;

@Configuration
@EnableConfigurationProperties(value={EurekaClientOAuth2Properties.class})
@ConditionalOnClass(value={EurekaClientConfig.class})
@ConditionalOnProperty(prefix="eureka.client.oauth2", name={"client-id", "client-secret", "access-token-uri"})
@AutoConfigureBefore(value={EurekaClientAutoConfiguration.class})
public class EurekaClientOAuth2AutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={DiscoveryClient.DiscoveryClientOptionalArgs.class})
    public OAuth2DiscoveryClientOptionalArgs discoveryClientOptionalArgs(EurekaClientOAuth2Properties eurekaClientOAuth2Properties) {
        ClientRegistration clientRegistration = ClientRegistration.withRegistrationId((String)"eureka-client").clientId(eurekaClientOAuth2Properties.getClientId()).clientSecret(eurekaClientOAuth2Properties.getClientSecret()).tokenUri(eurekaClientOAuth2Properties.getAccessTokenUri()).authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).build();
        return new OAuth2DiscoveryClientOptionalArgs(clientRegistration);
    }
}

