/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.service.registry;

import com.netflix.discovery.EurekaClientConfig;
import io.pivotal.spring.cloud.service.registry.EurekaClientOAuth2HttpRequestFactorySupplier;
import io.pivotal.spring.cloud.service.registry.EurekaClientOAuth2Properties;
import io.pivotal.spring.cloud.service.registry.OAuth2AuthorizedClientHttpRequestInterceptor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.netflix.eureka.RestTemplateTimeoutProperties;
import org.springframework.cloud.netflix.eureka.config.DiscoveryClientOptionalArgsConfiguration;
import org.springframework.cloud.netflix.eureka.http.DefaultEurekaClientHttpRequestFactorySupplier;
import org.springframework.cloud.netflix.eureka.http.EurekaClientHttpRequestFactorySupplier;
import org.springframework.context.annotation.Bean;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;

@AutoConfiguration(before={DiscoveryClientOptionalArgsConfiguration.class})
@EnableConfigurationProperties(value={EurekaClientOAuth2Properties.class, RestTemplateTimeoutProperties.class})
@ConditionalOnClass(value={EurekaClientConfig.class})
@ConditionalOnProperty(prefix="eureka.client.oauth2", name={"client-id", "client-secret", "access-token-uri"})
public class EurekaClientOAuth2AutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.web.client.RestTemplate"})
    EurekaClientHttpRequestFactorySupplier eurekaClientOAuth2HttpRequestFactorySupplier(EurekaClientOAuth2Properties eurekaClientOAuth2Properties, RestTemplateTimeoutProperties restTemplateTimeoutProperties) {
        ClientRegistration clientRegistration = ClientRegistration.withRegistrationId((String)"eureka-client").clientId(eurekaClientOAuth2Properties.getClientId()).clientSecret(eurekaClientOAuth2Properties.getClientSecret()).scope(eurekaClientOAuth2Properties.getScope()).tokenUri(eurekaClientOAuth2Properties.getAccessTokenUri()).authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).build();
        OAuth2AuthorizedClientHttpRequestInterceptor oAuth2AuthorizedClientHttpRequestInterceptor = new OAuth2AuthorizedClientHttpRequestInterceptor(clientRegistration);
        DefaultEurekaClientHttpRequestFactorySupplier defaultEurekaClientHttpRequestFactorySupplier = new DefaultEurekaClientHttpRequestFactorySupplier(restTemplateTimeoutProperties);
        return new EurekaClientOAuth2HttpRequestFactorySupplier(defaultEurekaClientHttpRequestFactorySupplier, oAuth2AuthorizedClientHttpRequestInterceptor);
    }
}

