/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.service.registry;

import java.util.Map;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequestTransformer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.support.HttpRequestWrapper;

public class SurgicalRoutingRequestTransformer
implements LoadBalancerRequestTransformer {
    public static final String CF_APP_GUID = "cfAppGuid";
    public static final String CF_INSTANCE_INDEX = "cfInstanceIndex";
    public static final String SURGICAL_ROUTING_HEADER = "X-CF-APP-INSTANCE";

    public HttpRequest transformRequest(HttpRequest request, ServiceInstance instance) {
        if (instance == null) {
            return request;
        }
        Map metadata = instance.getMetadata();
        if (!metadata.containsKey(CF_APP_GUID) || !metadata.containsKey(CF_INSTANCE_INDEX)) {
            return request;
        }
        final String headerValue = "%s:%s".formatted(metadata.get(CF_APP_GUID), metadata.get(CF_INSTANCE_INDEX));
        return new HttpRequestWrapper(request){

            public HttpHeaders getHeaders() {
                HttpHeaders headers = new HttpHeaders();
                headers.putAll((Map)super.getHeaders());
                headers.add(SurgicalRoutingRequestTransformer.SURGICAL_ROUTING_HEADER, headerValue);
                return headers;
            }
        };
    }
}

