/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.service.registry;

import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class EurekaClientEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    static final String ZONE_CONFIGURATION_FLAG = "scs.starters.eureka.client.zone.configuration.enabled";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (this.isEnabled((Environment)environment)) {
            environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("EurekaClientLoadBalancerZonePreference", Map.of("spring.cloud.loadbalancer.configurations", "zone-preference")));
        }
    }

    public int getOrder() {
        return -2147483637;
    }

    private boolean isEnabled(Environment environment) {
        return (Boolean)environment.getProperty(ZONE_CONFIGURATION_FLAG, Boolean.class, (Object)false);
    }
}

