/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.service.registry;

import io.pivotal.spring.cloud.service.registry.OAuth2AuthorizedClientHttpRequestInterceptor;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.springframework.cloud.netflix.eureka.http.DefaultEurekaClientHttpRequestFactorySupplier;
import org.springframework.cloud.netflix.eureka.http.EurekaClientHttpRequestFactorySupplier;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.InterceptingClientHttpRequestFactory;

public class EurekaClientOAuth2HttpRequestFactorySupplier
implements EurekaClientHttpRequestFactorySupplier {
    private final EurekaClientHttpRequestFactorySupplier defaultEurekaClientHttpRequestFactorySupplier;
    private final OAuth2AuthorizedClientHttpRequestInterceptor oAuth2AuthorizedClientHttpRequestInterceptor;

    public EurekaClientOAuth2HttpRequestFactorySupplier(DefaultEurekaClientHttpRequestFactorySupplier defaultEurekaClientHttpRequestFactorySupplier, OAuth2AuthorizedClientHttpRequestInterceptor oAuth2AuthorizedClientHttpRequestInterceptor) {
        this.defaultEurekaClientHttpRequestFactorySupplier = defaultEurekaClientHttpRequestFactorySupplier;
        this.oAuth2AuthorizedClientHttpRequestInterceptor = oAuth2AuthorizedClientHttpRequestInterceptor;
    }

    public ClientHttpRequestFactory get(SSLContext sslContext, HostnameVerifier hostnameVerifier) {
        ClientHttpRequestFactory clientHttpRequestFactory = this.defaultEurekaClientHttpRequestFactorySupplier.get(sslContext, hostnameVerifier);
        return new InterceptingClientHttpRequestFactory(clientHttpRequestFactory, List.of(this.oAuth2AuthorizedClientHttpRequestInterceptor));
    }
}

