/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.service.registry;

import java.io.IOException;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.oauth2.client.AuthorizedClientServiceOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;

public class OAuth2AuthorizedClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private final AuthorizedClientServiceOAuth2AuthorizedClientManager authorizedManager;
    private final OAuth2AuthorizeRequest authorizeRequest;

    public OAuth2AuthorizedClientHttpRequestInterceptor(ClientRegistration registration) {
        InMemoryClientRegistrationRepository repository = new InMemoryClientRegistrationRepository(new ClientRegistration[]{registration});
        InMemoryOAuth2AuthorizedClientService service = new InMemoryOAuth2AuthorizedClientService((ClientRegistrationRepository)repository);
        this.authorizedManager = new AuthorizedClientServiceOAuth2AuthorizedClientManager((ClientRegistrationRepository)repository, (OAuth2AuthorizedClientService)service);
        OAuth2AuthorizedClientProvider authorizedClientProvider = OAuth2AuthorizedClientProviderBuilder.builder().clientCredentials().build();
        this.authorizedManager.setAuthorizedClientProvider(authorizedClientProvider);
        this.authorizeRequest = OAuth2AuthorizeRequest.withClientRegistrationId((String)registration.getRegistrationId()).principal(registration.getRegistrationId()).build();
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        OAuth2AuthorizedClient authorize = this.authorizedManager.authorize(this.authorizeRequest);
        if (authorize != null) {
            request.getHeaders().add("Authorization", "Bearer " + authorize.getAccessToken().getTokenValue());
        }
        return execution.execute(request, body);
    }
}

