/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.config.java;

import java.util.LinkedHashMap;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.cloud.Cloud;
import org.springframework.cloud.CloudException;
import org.springframework.cloud.CloudFactory;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public abstract class ServiceInfoPropertySourceAdapter<T extends ServiceInfo>
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    public static final String SPRING_AUTOCONFIGURE_EXCLUDE = "spring.autoconfigure.exclude";
    private static final String RABBIT_AUTOCONFIG_CLASS = "org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration";
    private ConfigurableEnvironment environment;
    private Cloud cloud;

    protected abstract PropertySource<?> toPropertySource(T var1);

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        this.environment = event.getEnvironment();
        if (this.cloud != null) {
            return;
        }
        try {
            this.cloud = new CloudFactory().getCloud();
        }
        catch (CloudException e) {
            return;
        }
        for (ServiceInfo serviceInfo : this.cloud.getServiceInfos()) {
            try {
                PropertySource<?> propertySource = this.toPropertySource(serviceInfo);
                event.getEnvironment().getPropertySources().addFirst(propertySource);
            }
            catch (ClassCastException classCastException) {}
        }
        this.conditionallyExcludeRabbitAutoConfiguration();
    }

    private void conditionallyExcludeRabbitAutoConfiguration() {
        if (this.appIsBoundToRabbitMQ()) {
            return;
        }
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        String existingExcludes = this.environment.getProperty(SPRING_AUTOCONFIGURE_EXCLUDE);
        if (existingExcludes == null) {
            properties.put(SPRING_AUTOCONFIGURE_EXCLUDE, RABBIT_AUTOCONFIG_CLASS);
        } else if (!existingExcludes.contains(RABBIT_AUTOCONFIG_CLASS)) {
            properties.put(SPRING_AUTOCONFIGURE_EXCLUDE, "org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration," + existingExcludes);
        }
        MapPropertySource propertySource = new MapPropertySource("springCloudServicesRabbitAutoconfigExcluder", properties);
        this.environment.getPropertySources().addFirst((PropertySource)propertySource);
    }

    private boolean appIsBoundToRabbitMQ() {
        boolean hasEnvironmentBinding = this.environment.containsProperty("spring.rabbitmq.host") && !this.environment.getProperty("spring.rabbitmq.host").equals("localhost");
        boolean hasCloudBinding = false;
        try {
            Class<?> rabbitCFClass = Class.forName("org.springframework.amqp.rabbit.connection.ConnectionFactory");
            hasCloudBinding = !this.cloud.getServiceInfos(rabbitCFClass).isEmpty();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hasEnvironmentBinding || hasCloudBinding;
    }

    public int getOrder() {
        return -2147483644;
    }
}

