/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.service.eureka;

import io.pivotal.spring.cloud.config.java.ServiceInfoPropertySourceAdapter;
import io.pivotal.spring.cloud.service.common.EurekaServiceInfo;
import java.util.LinkedHashMap;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class EurekaServiceConnector
extends ServiceInfoPropertySourceAdapter<EurekaServiceInfo> {
    private static final String EUREKA_CLIENT = "eureka.client.";
    private static final String EUREKA_CLIENT_OAUTH2 = "eureka.client.oauth2.";
    private static final String EUREKA_API_PREFIX = "/eureka/";
    private static final String DEFAULT_REGION = "default";
    private static final String PROPERTY_SOURCE_NAME = "springCloudServicesServiceRegistry";

    @Override
    protected PropertySource<?> toPropertySource(EurekaServiceInfo eurekaServiceInfo) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("eureka.client.serviceUrl.defaultZone", eurekaServiceInfo.getUri() + EUREKA_API_PREFIX);
        map.put("eureka.client.region", DEFAULT_REGION);
        map.put("eureka.client.oauth2.clientId", eurekaServiceInfo.getClientId());
        map.put("eureka.client.oauth2.clientSecret", eurekaServiceInfo.getClientSecret());
        map.put("eureka.client.oauth2.accessTokenUri", eurekaServiceInfo.getAccessTokenUri());
        return new MapPropertySource(PROPERTY_SOURCE_NAME, map);
    }
}

