/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.service.config;

import io.pivotal.spring.cloud.service.config.ConfigClientOAuth2ResourceDetails;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.client.ConfigServicePropertySourceLocator;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={ConfigClientOAuth2ResourceDetails.class})
@ConditionalOnClass(value={ConfigServicePropertySourceLocator.class, OAuth2RestTemplate.class})
@ConditionalOnProperty(value={"spring.cloud.config.client.oauth2.client-id"})
public class ConfigClientOAuth2BootstrapConfiguration {

    @Configuration
    public class ConfigClientOAuth2Configurer {
        private final ConfigServicePropertySourceLocator locator;
        private final ConfigClientOAuth2ResourceDetails configClientOAuth2ResourceDetails;

        @Autowired
        public ConfigClientOAuth2Configurer(ConfigServicePropertySourceLocator locator, ConfigClientOAuth2ResourceDetails configClientOAuth2ResourceDetails) {
            Assert.notNull((Object)locator, (String)"Error injecting ConfigServicePropertySourceLocator, this can occurusing self signed certificates in Cloud Foundry without setting the TRUST_CERTS environment variable");
            this.locator = locator;
            this.configClientOAuth2ResourceDetails = configClientOAuth2ResourceDetails;
        }

        @PostConstruct
        public void init() {
            this.locator.setRestTemplate((RestTemplate)new OAuth2RestTemplate((OAuth2ProtectedResourceDetails)this.configClientOAuth2ResourceDetails));
        }
    }
}

