/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.buffer;

import io.pkts.buffer.AbstractBuffer;
import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.buffer.ByteBuffer;
import io.pkts.buffer.WriteNotSupportedException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class InputStreamBuffer
extends AbstractBuffer {
    private static final String CANNOT_WRITE_TO_AN_INPUT_STREAM_BUFFER = "Cannot write to an InputStreamBuffer";
    private static final String NOT_IMPLEMENTED_JUST_YET = "Not implemented just yet";
    private final InputStream is;
    private static final int DEFAULT_CAPACITY = 4096;
    private final List<java.nio.ByteBuffer> storage;
    private final int localCapacity;

    public InputStreamBuffer(InputStream is) {
        this(4096, is);
    }

    public InputStreamBuffer(int initialCapacity, InputStream is) {
        super(0, 0, 0, 0);
        assert (is != null);
        this.is = is;
        this.localCapacity = initialCapacity;
        this.storage = new ArrayList<java.nio.ByteBuffer>();
        this.storage.add(java.nio.ByteBuffer.allocate(this.localCapacity));
    }

    @Override
    public Buffer slice(int start, int stop) {
        int upperBoundary;
        this.checkIndex(this.lowerBoundary + start);
        this.checkIndex(this.lowerBoundary + stop - 1);
        java.nio.ByteBuffer buf = this.getWritingRow();
        int writerIndex = upperBoundary = this.lowerBoundary + stop;
        return new ByteBuffer(0, this.lowerBoundary + start, upperBoundary, writerIndex, buf.array());
    }

    @Override
    public byte readByte() throws IndexOutOfBoundsException, IOException {
        int read = this.internalReadBytes(1);
        if (read == -1) {
            throw new IndexOutOfBoundsException();
        }
        return this.getByte(this.readerIndex++);
    }

    @Override
    public byte peekByte() throws IndexOutOfBoundsException, IOException {
        int read = this.internalReadBytes(1);
        if (read == -1) {
            throw new IndexOutOfBoundsException();
        }
        return this.getByte(this.readerIndex);
    }

    @Override
    public Buffer readBytes(int length) throws IndexOutOfBoundsException, IOException {
        int readAtMost;
        if (!this.checkReadableBytesSafe(length)) {
            int availableBytes = this.getReadableBytes();
            int read = this.internalReadBytes(length - availableBytes);
            if (read == -1) {
                return null;
            }
            if (read + availableBytes < length) {
                throw new IndexOutOfBoundsException("Not enough bytes left in the stream. Wanted " + length + " but only read " + read);
            }
        }
        byte[] buf = new byte[length];
        for (int index = 0; index < length; index += readAtMost) {
            int spaceLeft = this.getAvailableLocalReadingSpace();
            readAtMost = Math.min(length - index, spaceLeft);
            int localIndex = this.getLocalReaderIndex();
            java.nio.ByteBuffer bb = this.getReadingRow();
            System.arraycopy(bb.array(), localIndex, buf, index, readAtMost);
            this.readerIndex += readAtMost;
        }
        return Buffers.wrap(buf);
    }

    private int internalReadBytes(int length) throws IOException {
        if (this.checkReadableBytesSafe(length)) {
            return length;
        }
        return this.readFromStream(length);
    }

    private int getLocalWriterIndex() {
        return this.writerIndex % this.localCapacity;
    }

    private int getLocalReaderIndex() {
        return this.readerIndex % this.localCapacity;
    }

    private int getAvailableLocalWritingSpace() {
        return this.localCapacity - this.getLocalWriterIndex();
    }

    private int getAvailableLocalReadingSpace() {
        return this.localCapacity - this.getLocalReaderIndex();
    }

    private java.nio.ByteBuffer getWritingRow() {
        int row = this.writerIndex / this.localCapacity;
        if (row >= this.storage.size()) {
            java.nio.ByteBuffer buf = java.nio.ByteBuffer.allocate(this.localCapacity);
            this.storage.add(buf);
            return buf;
        }
        return this.storage.get(row);
    }

    private java.nio.ByteBuffer getReadingRow() {
        int row = this.readerIndex / this.localCapacity;
        return this.storage.get(row);
    }

    private int readFromStream(int length) throws IOException {
        int total = 0;
        int actual = 0;
        while (total < length && actual != -1) {
            int localIndex = this.getLocalWriterIndex();
            int spaceLeft = this.getAvailableLocalWritingSpace();
            int readAtMost = Math.min(length - total, spaceLeft);
            java.nio.ByteBuffer bb = this.getWritingRow();
            actual = this.is.read(bb.array(), localIndex, readAtMost);
            if (actual <= 0) continue;
            this.upperBoundary += actual;
            this.writerIndex = this.upperBoundary;
            total += actual;
        }
        return total;
    }

    @Override
    public int getReadableBytes() {
        return super.getReadableBytes();
    }

    @Override
    public boolean hasReadableBytes() {
        if (!this.checkReadableBytesSafe(1)) {
            try {
                return this.internalReadBytes(100) >= 1;
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public byte[] getArray() {
        return null;
    }

    @Override
    public byte getByte(int index) throws IndexOutOfBoundsException, IOException {
        this.checkIndex(this.lowerBoundary + index);
        java.nio.ByteBuffer bb = this.getWritingRow();
        return bb.get(this.lowerBoundary + index);
    }

    @Override
    protected void checkIndex(int index) throws IndexOutOfBoundsException {
        int missingBytes = index + 1 - (this.lowerBoundary + this.capacity());
        if (missingBytes <= 0) {
            return;
        }
        try {
            int read = this.readFromStream(missingBytes);
            if (read == -1 || read < missingBytes) {
                throw new IndexOutOfBoundsException();
            }
        }
        catch (IOException e) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public long readUnsignedInt() throws IndexOutOfBoundsException {
        return 0L;
    }

    @Override
    public int readInt() throws IndexOutOfBoundsException {
        return 0;
    }

    @Override
    public int getInt(int index) throws IndexOutOfBoundsException {
        return 0;
    }

    @Override
    public short getShort(int index) throws IndexOutOfBoundsException {
        return 0;
    }

    @Override
    public int readUnsignedShort() throws IndexOutOfBoundsException {
        return 0;
    }

    @Override
    public int getUnsignedShort(int index) throws IndexOutOfBoundsException {
        return 0;
    }

    @Override
    public short readShort() throws IndexOutOfBoundsException {
        return 0;
    }

    @Override
    public short getUnsignedByte(int index) throws IndexOutOfBoundsException {
        return 0;
    }

    @Override
    public String dumpAsHex() {
        return null;
    }

    @Override
    public void setByte(int index, byte value) throws IndexOutOfBoundsException {
    }

    @Override
    public void setUnsignedByte(int index, short value) throws IndexOutOfBoundsException {
    }

    @Override
    public void setUnsignedShort(int index, int value) throws IndexOutOfBoundsException {
    }

    @Override
    public Buffer clone() {
        return null;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        try {
            Buffer b = (Buffer)other;
            return Arrays.equals(this.getArray(), b.getArray());
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public boolean equalsIgnoreCase(Object other) {
        throw new RuntimeException("Sorry, InputStreamBuffer.equalsIgnoreCase isn't implemented yet");
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.getArray());
    }

    @Override
    public String toString() {
        Buffer b = this.slice();
        return b.toString();
    }

    @Override
    public int getWritableBytes() {
        return 0;
    }

    @Override
    public boolean hasWritableBytes() {
        return false;
    }

    @Override
    public void write(byte[] bytes) throws IndexOutOfBoundsException, WriteNotSupportedException {
        throw new WriteNotSupportedException(CANNOT_WRITE_TO_AN_INPUT_STREAM_BUFFER);
    }

    public void getBytes() {
    }

    @Override
    public void getBytes(Buffer dst) {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public void getBytes(byte[] dst) throws IndexOutOfBoundsException {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public void getBytes(int index, Buffer dst) throws IndexOutOfBoundsException {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public void setInt(int index, int value) throws IndexOutOfBoundsException {
        throw new RuntimeException(NOT_IMPLEMENTED_JUST_YET);
    }

    @Override
    public void write(int value) throws IndexOutOfBoundsException, WriteNotSupportedException {
        throw new WriteNotSupportedException(CANNOT_WRITE_TO_AN_INPUT_STREAM_BUFFER);
    }

    @Override
    public void write(long value) throws IndexOutOfBoundsException, WriteNotSupportedException {
        throw new WriteNotSupportedException(CANNOT_WRITE_TO_AN_INPUT_STREAM_BUFFER);
    }

    @Override
    public void writeAsString(int value) throws IndexOutOfBoundsException, WriteNotSupportedException {
        throw new WriteNotSupportedException(CANNOT_WRITE_TO_AN_INPUT_STREAM_BUFFER);
    }

    @Override
    public void writeAsString(long value) throws IndexOutOfBoundsException, WriteNotSupportedException {
        throw new WriteNotSupportedException(CANNOT_WRITE_TO_AN_INPUT_STREAM_BUFFER);
    }

    @Override
    public void setUnsignedInt(int index, long value) throws IndexOutOfBoundsException {
    }
}

