/*
 * Decompiled with CFR 0.152.
 */
package io.pkts;

import io.pkts.PacketHandler;
import io.pkts.PcapOutputStream;
import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.filters.Filter;
import io.pkts.filters.FilterException;
import io.pkts.filters.FilterFactory;
import io.pkts.filters.FilterParseException;
import io.pkts.frame.PcapGlobalHeader;
import io.pkts.framer.FramerManager;
import io.pkts.framer.PcapFramer;
import io.pkts.packet.PCapPacket;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;

public class Pcap {
    private final PcapGlobalHeader header;
    private final Buffer buffer;
    private final FramerManager framerManager;
    private Filter filter = null;
    private final FilterFactory filterFactory = FilterFactory.getInstance();

    private Pcap(PcapGlobalHeader header, Buffer buffer) {
        assert (header != null);
        assert (buffer != null);
        this.header = header;
        this.buffer = buffer;
        this.framerManager = FramerManager.getInstance();
    }

    public void setFilter(String expression) throws FilterParseException {
        if (expression != null && !expression.isEmpty()) {
            this.filter = this.filterFactory.createFilter(expression);
        }
    }

    public void loop(PacketHandler callback) throws IOException {
        ByteOrder byteOrder = this.header.getByteOrder();
        PcapFramer framer = new PcapFramer(this.header, this.framerManager);
        boolean count = true;
        PCapPacket packet = null;
        boolean processNext = true;
        while ((packet = framer.frame((PCapPacket)null, this.buffer)) != null && processNext) {
            try {
                long time = packet.getArrivalTime();
                this.framerManager.tick(time);
                if (this.filter == null) {
                    processNext = callback.nextPacket(packet);
                    continue;
                }
                if (this.filter == null || !this.filter.accept(packet)) continue;
                processNext = callback.nextPacket(packet);
            }
            catch (FilterException e) {
                System.err.println("WARN: the filter complained about the last frame. Msg (if any) - " + e.getMessage());
            }
        }
    }

    public PcapOutputStream createOutputStream(OutputStream out) throws IllegalArgumentException {
        return PcapOutputStream.create(this.header, out);
    }

    public static Pcap openStream(InputStream is) throws IOException {
        Buffer stream = Buffers.wrap((InputStream)is);
        PcapGlobalHeader header = PcapGlobalHeader.parse(stream);
        return new Pcap(header, stream);
    }

    public static Pcap openStream(File file) throws FileNotFoundException, IOException {
        FileInputStream is = new FileInputStream(file);
        return Pcap.openStream(is);
    }

    public static Pcap openStream(String file) throws FileNotFoundException, IOException {
        return Pcap.openStream(new File(file));
    }

    public void close() {
    }
}

