/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.filters;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.filters.FilterException;
import io.pkts.filters.SipFilter;
import io.pkts.packet.Packet;
import io.pkts.packet.PacketParseException;
import io.pkts.packet.sip.SipPacket;
import io.pkts.packet.sip.SipParseException;
import io.pkts.protocol.Protocol;
import java.io.IOException;

public final class SipCallIdFilter
extends SipFilter {
    private final Buffer callId;

    public SipCallIdFilter(String callId) {
        this.callId = Buffers.wrap((String)callId);
    }

    @Override
    public boolean accept(Packet packet) throws FilterException {
        try {
            if (super.accept(packet)) {
                SipPacket msg = (SipPacket)packet.getPacket(Protocol.SIP);
                return msg.getCallIDHeader().getValue().equals((Object)this.callId);
            }
        }
        catch (SipParseException e) {
            throw new FilterException("Unable to process the frame due to SipParseException", e);
        }
        catch (IOException e) {
            throw new FilterException("Unable to process the frame due to IOException", e);
        }
        catch (PacketParseException e) {
            throw new FilterException("Unable to process the frame due to parse issue of the SIP Message", e);
        }
        return false;
    }

    public String getCallId() {
        return this.callId.toString();
    }
}

