/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.framer;

import io.pkts.buffer.Buffer;
import io.pkts.frame.UnknownEtherType;
import io.pkts.framer.Framer;
import io.pkts.packet.MACPacket;
import io.pkts.packet.PCapPacket;
import io.pkts.packet.impl.MACPacketImpl;
import io.pkts.protocol.Protocol;
import java.io.IOException;
import java.io.OutputStream;

public class EthernetFramer
implements Framer<PCapPacket> {
    @Override
    public Protocol getProtocol() {
        return Protocol.ETHERNET_II;
    }

    @Override
    public MACPacket frame(PCapPacket parent, Buffer buffer) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException("The parent frame cannot be null");
        }
        Buffer headers = buffer.readBytes(14);
        byte b1 = headers.getByte(12);
        byte b2 = headers.getByte(13);
        try {
            EthernetFramer.getEtherType(b1, b2);
        }
        catch (UnknownEtherType e) {
            throw new RuntimeException("uknown ether type");
        }
        Buffer payload = buffer.slice(buffer.capacity());
        return new MACPacketImpl(Protocol.ETHERNET_II, parent, headers, payload);
    }

    public static EtherType getEtherType(byte b1, byte b2) throws UnknownEtherType {
        EtherType type = EthernetFramer.getEtherTypeSafe(b1, b2);
        if (type != null) {
            return type;
        }
        throw new UnknownEtherType(b1, b2);
    }

    public static EtherType getEtherTypeSafe(byte b1, byte b2) {
        if (b1 == 8 && b2 == 0) {
            return EtherType.IPv4;
        }
        if (b1 == -122 && b2 == -35) {
            return EtherType.IPv6;
        }
        return null;
    }

    @Override
    public boolean accept(Buffer data) {
        return false;
    }

    public static enum EtherType {
        IPv4(8, 0),
        IPv6(-122, -35);

        private final byte b1;
        private final byte b2;

        private EtherType(byte b1, byte b2) {
            this.b1 = b1;
            this.b2 = b2;
        }

        public void write(OutputStream out) throws IOException {
            out.write(this.b1);
            out.write(this.b2);
        }
    }
}

