/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.framer;

import io.pkts.buffer.Buffer;
import io.pkts.framer.Framer;
import io.pkts.packet.IPPacket;
import io.pkts.packet.MACPacket;
import io.pkts.packet.impl.IPPacketImpl;
import io.pkts.protocol.Protocol;
import java.io.IOException;

public class IPv4Framer
implements Framer<MACPacket> {
    @Override
    public Protocol getProtocol() {
        return Protocol.IPv4;
    }

    @Override
    public IPPacket frame(MACPacket parent, Buffer payload) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException("The parent frame cannot be null");
        }
        Buffer headers = payload.readBytes(20);
        byte b = headers.getByte(0);
        int version = b >>> 5 & 0xF;
        int length = b & 0xF;
        int options = 0;
        if (length > 5) {
            options = payload.readInt();
        }
        Buffer data = payload.slice();
        return new IPPacketImpl(parent, headers, options, data);
    }

    @Override
    public boolean accept(Buffer data) {
        return false;
    }
}

