/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.framer;

import io.pkts.buffer.Buffer;
import io.pkts.framer.Framer;
import io.pkts.packet.TransportPacket;
import io.pkts.packet.rtp.RtpPacket;
import io.pkts.packet.rtp.impl.RtpPacketImpl;
import io.pkts.protocol.Protocol;
import java.io.IOException;

public final class RTPFramer
implements Framer<TransportPacket> {
    @Override
    public Protocol getProtocol() {
        return Protocol.RTP;
    }

    @Override
    public boolean accept(Buffer data) throws IOException {
        byte b;
        if (data.getReadableBytes() < 12) {
            data.markReaderIndex();
            try {
                Buffer b2 = data.readBytes(12);
                if (b2.capacity() < 12) {
                    return false;
                }
            }
            catch (IndexOutOfBoundsException b2) {
                // empty catch block
            }
            data.resetReaderIndex();
        }
        if (((b = data.getByte(0)) & 0xC0) >> 6 != 2) {
            return false;
        }
        byte b2 = data.getByte(1);
        return b2 != -56 && b2 != -55 && b2 != -54 && b2 != -53 && b2 != -52;
    }

    @Override
    public RtpPacket frame(TransportPacket parent, Buffer buffer) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException("The parent frame cannot be null");
        }
        int index = buffer.getReaderIndex();
        try {
            Buffer headers = buffer.readBytes(12);
            Byte b = headers.getByte(0);
            boolean hasPadding = (b & 0x20) == 32;
            boolean hasExtension = (b & 0x10) == 16;
            int csrcCount = b & 0xF;
            if (hasExtension) {
                short extensionHeaders = buffer.readShort();
                int length = buffer.readUnsignedShort();
                Buffer buffer2 = buffer.readBytes(length);
            }
            if (hasPadding || hasExtension || csrcCount > 0) {
                // empty if block
            }
            Buffer payload = buffer.slice();
            return new RtpPacketImpl(parent, headers, payload);
        }
        catch (IndexOutOfBoundsException e) {
            buffer.setReaderIndex(index);
            throw e;
        }
    }
}

