/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.framer;

import io.pkts.buffer.Buffer;
import io.pkts.framer.Framer;
import io.pkts.packet.IPPacket;
import io.pkts.packet.UDPPacket;
import io.pkts.packet.impl.UdpPacketImpl;
import io.pkts.protocol.Protocol;
import java.io.IOException;

public class UDPFramer
implements Framer<IPPacket> {
    @Override
    public Protocol getProtocol() {
        return Protocol.UDP;
    }

    @Override
    public UDPPacket frame(IPPacket parent, Buffer buffer) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException("The parent frame cannot be null");
        }
        Buffer headers = buffer.readBytes(8);
        Buffer payload = buffer.slice();
        if (payload.isEmpty()) {
            return new UdpPacketImpl(parent, headers, null);
        }
        return new UdpPacketImpl(parent, headers, payload);
    }

    @Override
    public boolean accept(Buffer data) {
        return false;
    }
}

