/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.impl;

import io.pkts.buffer.Buffer;
import io.pkts.packet.Packet;
import io.pkts.protocol.Protocol;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AbstractPacket
implements Packet {
    private final Protocol protocol;
    private final Buffer payload;
    private final Packet parent;
    private Packet nextPacket;

    public AbstractPacket(Protocol p, Packet parent, Buffer payload) {
        assert (p != null);
        this.protocol = p;
        this.payload = payload;
        this.parent = parent;
    }

    @Override
    public void verify() {
    }

    @Override
    public final void write(OutputStream out) throws IOException {
        if (this.nextPacket != null) {
            this.nextPacket.write(out);
        } else {
            this.write(out, this.payload);
        }
    }

    @Override
    public abstract Packet clone();

    @Override
    public Packet getParentPacket() {
        return this.parent;
    }

    @Override
    public boolean hasProtocol(Protocol p) throws IOException {
        if (p == null) {
            return false;
        }
        try {
            Packet packet = this.getPacket(p);
            return packet != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public Packet getPacket(Protocol p) throws IOException {
        if (this.protocol == p) {
            return this;
        }
        Packet child = this.getNextPacket();
        if (child != null && child.getProtocol() == p) {
            return child;
        }
        if (child == null) {
            return this.checkParent(p);
        }
        return child.getPacket(p);
    }

    public Packet checkParent(Protocol p) {
        Packet current;
        for (current = this.parent; current != null && current.getProtocol() != p; current = current.getParentPacket()) {
        }
        return current;
    }

    @Override
    public String getName() {
        return this.protocol.getName();
    }

    @Override
    public Buffer getPayload() {
        if (this.payload != null) {
            return this.payload.slice();
        }
        return null;
    }
}

