/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.framer.IPv4Framer;
import io.pkts.packet.IPPacket;
import io.pkts.packet.MACPacket;
import io.pkts.packet.PCapPacket;
import io.pkts.packet.impl.AbstractPacket;
import io.pkts.protocol.Protocol;
import java.io.IOException;
import java.io.OutputStream;

public final class MACPacketImpl
extends AbstractPacket
implements MACPacket {
    private static final IPv4Framer framer = new IPv4Framer();
    private final PCapPacket parent;
    private final String sourceMacAddress;
    private final String destinationMacAddress;
    private final Buffer headers;

    public static MACPacketImpl create(PCapPacket parent, Buffer headers) {
        if (headers.capacity() != 14) {
            throw new IllegalArgumentException("Not enough bytes to create this header");
        }
        if (parent == null) {
            throw new IllegalArgumentException("The parent packet cannot be null");
        }
        return new MACPacketImpl(Protocol.ETHERNET_II, parent, headers, null);
    }

    public MACPacketImpl(Protocol protocol, PCapPacket parent, Buffer headers, Buffer payload) {
        super(protocol, parent, payload);
        this.parent = parent;
        this.headers = headers;
        this.sourceMacAddress = null;
        this.destinationMacAddress = null;
    }

    @Override
    public final String getSourceMacAddress() {
        if (this.sourceMacAddress != null) {
            return this.sourceMacAddress;
        }
        try {
            return MACPacketImpl.toHexString(this.headers, 6, 6);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read data from the underlying Buffer.", e);
        }
    }

    public static String toHexString(Buffer buffer, int start, int length) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < start + length; ++i) {
            byte b = buffer.getByte(i);
            sb.append(String.format("%02X", b));
            if (i >= start + length - 1) continue;
            sb.append(":");
        }
        return sb.toString();
    }

    @Override
    public final String getDestinationMacAddress() {
        if (this.destinationMacAddress != null) {
            return this.destinationMacAddress;
        }
        try {
            return MACPacketImpl.toHexString(this.headers, 0, 6);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read data from the underlying Buffer.", e);
        }
    }

    @Override
    public void verify() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Destination Mac Address: ").append(this.destinationMacAddress).append(" Source Mac Address: ").append(this.sourceMacAddress);
        return sb.toString();
    }

    @Override
    public long getArrivalTime() {
        return this.parent.getArrivalTime();
    }

    @Override
    public void write(OutputStream out, Buffer payload) throws IOException {
        this.parent.write(out, Buffers.wrap((Buffer)this.headers, (Buffer)payload));
    }

    @Override
    public void setSourceMacAddress(String macAddress) {
        this.setMacAddress(macAddress, true);
    }

    @Override
    public void setDestinationMacAddress(String macAddress) {
        this.setMacAddress(macAddress, false);
    }

    private void setMacAddress(String macAddress, boolean setSourceMacAddress) throws IllegalArgumentException {
        if (macAddress == null || macAddress.isEmpty()) {
            throw new IllegalArgumentException("Null or empty string cannot be a valid MAC Address.");
        }
        String[] segments = macAddress.split(":");
        if (segments.length != 6) {
            throw new IllegalArgumentException("Invalid MAC Address. Not enough segments");
        }
        int offset = setSourceMacAddress ? 6 : 0;
        for (int i = 0; i < 6; ++i) {
            byte b = (byte)((Character.digit(segments[i].charAt(0), 16) << 4) + Character.digit(segments[i].charAt(1), 16));
            this.headers.setByte(i + offset, b);
        }
    }

    @Override
    public MACPacket clone() {
        PCapPacket pkt = this.parent.clone();
        return new MACPacketImpl(this.getProtocol(), pkt, this.headers.clone(), this.getPayload().clone());
    }

    @Override
    public long getTotalLength() {
        return this.parent.getTotalLength();
    }

    @Override
    public long getCapturedLength() {
        return this.parent.getCapturedLength();
    }

    @Override
    public IPPacket getNextPacket() throws IOException {
        Buffer payload = this.getPayload();
        if (payload == null) {
            return null;
        }
        return framer.frame(this, payload);
    }
}

