/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.impl;

import io.pkts.buffer.Buffer;
import io.pkts.frame.PcapRecordHeader;
import io.pkts.framer.EthernetFramer;
import io.pkts.framer.SllFramer;
import io.pkts.packet.MACPacket;
import io.pkts.packet.PCapPacket;
import io.pkts.packet.impl.AbstractPacket;
import io.pkts.protocol.Protocol;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class PCapPacketImpl
extends AbstractPacket
implements PCapPacket {
    private final PcapRecordHeader pcapHeader;
    private static final SllFramer sllFramer = new SllFramer();
    private static final EthernetFramer ethernetFramer = new EthernetFramer();

    public PCapPacketImpl(PcapRecordHeader header, Buffer payload) {
        super(Protocol.PCAP, null, payload);
        this.pcapHeader = header;
    }

    @Override
    public long getArrivalTime() {
        return this.pcapHeader.getTimeStampSeconds() * 1000000L + this.pcapHeader.getTimeStampMicroSeconds();
    }

    @Override
    public long getTotalLength() {
        return this.pcapHeader.getTotalLength();
    }

    @Override
    public long getCapturedLength() {
        return this.pcapHeader.getCapturedLength();
    }

    @Override
    public void verify() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS");
        Date date = new Date(this.getArrivalTime() / 1000L);
        sb.append("Arrival Time: ").append(formatter.format(date)).append(" Epoch Time: ").append(this.pcapHeader.getTimeStampSeconds()).append(".").append(this.pcapHeader.getTimeStampMicroSeconds()).append(" Frame Length: ").append(this.getTotalLength()).append(" Capture Length: ").append(this.getCapturedLength());
        return sb.toString();
    }

    @Override
    public void write(OutputStream out, Buffer payload) throws IOException {
        int size = payload.getReadableBytes();
        this.pcapHeader.setCapturedLength(size);
        this.pcapHeader.setTotalLength(size);
        this.pcapHeader.write(out);
        out.write(payload.getArray());
    }

    @Override
    public PCapPacket clone() {
        throw new RuntimeException("not implemente yet");
    }

    @Override
    public MACPacket getNextPacket() throws IOException {
        Buffer payload = this.getPayload();
        if (payload == null) {
            return null;
        }
        if (sllFramer.accept(payload)) {
            return sllFramer.frame(this, payload);
        }
        return ethernetFramer.frame(this, payload);
    }
}

