/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.impl;

import io.pkts.buffer.Buffer;
import io.pkts.framer.RTPFramer;
import io.pkts.framer.SIPFramer;
import io.pkts.packet.IPPacket;
import io.pkts.packet.Packet;
import io.pkts.packet.TransportPacket;
import io.pkts.packet.impl.AbstractPacket;
import io.pkts.packet.impl.UnknownApplicationPacketImpl;
import io.pkts.packet.rtp.RtpPacket;
import io.pkts.protocol.Protocol;
import java.io.IOException;

public abstract class TransportPacketImpl
extends AbstractPacket
implements TransportPacket {
    private static final SIPFramer sipFramer = new SIPFramer();
    private static final RTPFramer rtpFramer = new RTPFramer();
    private final IPPacket parent;
    private final Buffer headers;

    protected TransportPacketImpl(IPPacket parent, Protocol protocol, Buffer headers, Buffer payload) {
        super(protocol, parent, payload);
        assert (parent != null);
        this.parent = parent;
        this.headers = headers;
    }

    @Override
    public boolean isUDP() {
        return false;
    }

    @Override
    public boolean isTCP() {
        return false;
    }

    @Override
    public final int getSourcePort() {
        return this.headers.getUnsignedShort(0);
    }

    @Override
    public final void setSourcePort(int port) {
        this.headers.setUnsignedShort(0, port);
    }

    @Override
    public final int getDestinationPort() {
        return this.headers.getUnsignedShort(2);
    }

    @Override
    public final void setDestinationPort(int port) {
        this.headers.setUnsignedShort(2, port);
    }

    @Override
    public void verify() {
    }

    @Override
    public final long getArrivalTime() {
        return this.parent.getArrivalTime();
    }

    @Override
    public int getRawSourceIp() {
        return this.parent.getRawSourceIp();
    }

    @Override
    public final String getSourceIP() {
        return this.parent.getSourceIP();
    }

    @Override
    public int getRawDestinationIp() {
        return this.parent.getRawDestinationIp();
    }

    @Override
    public final String getDestinationIP() {
        return this.parent.getDestinationIP();
    }

    @Override
    public final String getSourceMacAddress() {
        return this.parent.getSourceMacAddress();
    }

    @Override
    public final String getDestinationMacAddress() {
        return this.parent.getDestinationMacAddress();
    }

    @Override
    public final long getTotalLength() {
        return this.parent.getTotalLength();
    }

    @Override
    public final void setSourceMacAddress(String macAddress) {
        this.parent.setSourceMacAddress(macAddress);
    }

    @Override
    public final void setDestinationMacAddress(String macAddress) {
        this.parent.setDestinationMacAddress(macAddress);
    }

    @Override
    public final void setSourceIP(int a, int b, int c, int d) {
        this.parent.setSourceIP(a, b, c, d);
    }

    @Override
    public final void setDestinationIP(int a, int b, int c, int d) {
        this.parent.setDestinationIP(a, b, c, d);
    }

    @Override
    public final void setSourceIP(String sourceIp) {
        this.parent.setSourceIP(sourceIp);
    }

    @Override
    public final void setDestinationIP(String destinationIP) {
        this.parent.setDestinationIP(destinationIP);
    }

    @Override
    public final int getIpChecksum() {
        return this.parent.getIpChecksum();
    }

    @Override
    public final boolean verifyIpChecksum() {
        return this.parent.verifyIpChecksum();
    }

    @Override
    public final void setSourceIP(byte a, byte b, byte c, byte d) {
        this.parent.setSourceIP(a, b, c, d);
    }

    @Override
    public final void setDestinationIP(byte a, byte b, byte c, byte d) {
        this.parent.setDestinationIP(a, b, c, d);
    }

    @Override
    public final void reCalculateChecksum() {
        this.parent.reCalculateChecksum();
    }

    @Override
    public abstract TransportPacket clone();

    protected IPPacket getParent() {
        return this.parent;
    }

    @Override
    public long getCapturedLength() {
        return 0L;
    }

    @Override
    public Packet getNextPacket() throws IOException {
        RtpPacket rtp;
        Buffer payload = this.getPayload();
        if (payload == null || payload.isEmpty()) {
            return null;
        }
        if (sipFramer.accept(payload)) {
            return sipFramer.frame(this, payload);
        }
        if (rtpFramer.accept(payload) && (rtp = this.frameRtp(payload)) != null) {
            return rtp;
        }
        return new UnknownApplicationPacketImpl(this, payload);
    }

    private RtpPacket frameRtp(Buffer payload) throws IOException {
        try {
            return rtpFramer.frame(this, payload);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public int getTotalIPLength() {
        return this.parent.getTotalIPLength();
    }

    @Override
    public int getVersion() {
        return this.parent.getVersion();
    }

    @Override
    public int getHeaderLength() {
        return this.parent.getHeaderLength();
    }

    @Override
    public int getIdentification() {
        return this.parent.getIdentification();
    }

    @Override
    public boolean isFragmented() {
        return this.parent.isFragmented();
    }

    @Override
    public boolean isReservedFlagSet() {
        return this.parent.isReservedFlagSet();
    }

    @Override
    public boolean isDontFragmentSet() {
        return this.parent.isDontFragmentSet();
    }

    @Override
    public boolean isMoreFragmentsSet() {
        return this.parent.isMoreFragmentsSet();
    }

    @Override
    public short getFragmentOffset() {
        return this.parent.getFragmentOffset();
    }
}

