/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.IPPacket;
import io.pkts.packet.TransportPacket;
import io.pkts.packet.UDPPacket;
import io.pkts.packet.impl.TransportPacketImpl;
import io.pkts.protocol.Protocol;
import java.io.IOException;
import java.io.OutputStream;

public final class UdpPacketImpl
extends TransportPacketImpl
implements UDPPacket {
    private final Buffer headers;
    private final IPPacket parent;

    public UdpPacketImpl(IPPacket parent, Buffer headers, Buffer payload) {
        super(parent, Protocol.UDP, headers, payload);
        this.parent = parent;
        this.headers = headers;
    }

    @Override
    public boolean isUDP() {
        return true;
    }

    public int getLength() {
        return this.headers.getUnsignedShort(4);
    }

    public void setLength(int length) {
        this.headers.setUnsignedShort(4, length);
    }

    public int getChecksum() {
        return this.headers.getUnsignedShort(6);
    }

    @Override
    public TransportPacket clone() {
        IPPacket parent = this.getParent().clone();
        return new UdpPacketImpl(parent, this.headers.clone(), this.getPayload().clone());
    }

    @Override
    public final void write(OutputStream out, Buffer payload) throws IOException {
        int size = this.headers.getReadableBytes() + (payload != null ? payload.getReadableBytes() : 0);
        this.setLength(size);
        this.reCalculateChecksum();
        Buffer pkt = Buffers.wrap((Buffer)this.headers, (Buffer)payload);
        this.parent.write(out, pkt);
    }
}

