/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.rtp.impl;

import io.pkts.buffer.Buffer;
import io.pkts.packet.Packet;
import io.pkts.packet.TransportPacket;
import io.pkts.packet.impl.AbstractPacket;
import io.pkts.packet.rtp.RtpPacket;
import io.pkts.protocol.Protocol;
import java.io.IOException;
import java.io.OutputStream;

public final class RtpPacketImpl
extends AbstractPacket
implements RtpPacket {
    private final TransportPacket parent;
    private final Buffer headers;
    private final Buffer payload;

    public RtpPacketImpl(TransportPacket parent, Buffer headers, Buffer payload) {
        super(Protocol.RTP, parent, payload);
        this.parent = parent;
        this.headers = headers;
        this.payload = payload;
    }

    @Override
    public int getVersion() {
        try {
            return (this.headers.getByte(0) & 0xC0) >> 6;
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeException("Unable to parse out the RTP version, not enough data", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse out the RTP version, IOException when trying.", e);
        }
    }

    @Override
    public boolean hasPadding() throws IOException {
        return (this.headers.getByte(0) & 0x20) == 32;
    }

    @Override
    public boolean hasExtensions() throws IOException {
        return (this.headers.getByte(0) & 0x10) == 16;
    }

    @Override
    public boolean hasMarker() throws IOException {
        return (this.headers.getByte(1) & 0xFF & 0x80) == 128;
    }

    @Override
    public int getPayloadType() throws IOException {
        return this.headers.getByte(1) & 0xFF & 0x7F;
    }

    @Override
    public int getSeqNumber() throws IOException {
        return this.headers.getShort(2);
    }

    @Override
    public long getTimestamp() throws IOException {
        return (long)(this.headers.getByte(4) & 0xFF) << 24 | (long)(this.headers.getByte(5) & 0xFF) << 16 | (long)(this.headers.getByte(6) & 0xFF) << 8 | (long)(this.headers.getByte(7) & 0xFF);
    }

    @Override
    public long getSyncronizationSource() throws IOException {
        return (long)(this.headers.getByte(8) & 0xFF) << 24 | (long)(this.headers.getByte(9) & 0xFF) << 16 | (long)(this.headers.getByte(10) & 0xFF) << 8 | (long)(this.headers.getByte(11) & 0xFF);
    }

    @Override
    public int getContributingSource() throws IOException {
        return this.headers.getByte(0) & 0xF;
    }

    @Override
    public void verify() {
    }

    @Override
    public long getArrivalTime() {
        return this.parent.getArrivalTime();
    }

    @Override
    public int getSourcePort() {
        return this.parent.getSourcePort();
    }

    @Override
    public int getDestinationPort() {
        return this.parent.getDestinationPort();
    }

    @Override
    public int getRawSourceIp() {
        return this.parent.getRawSourceIp();
    }

    @Override
    public String getSourceIP() {
        return this.parent.getSourceIP();
    }

    @Override
    public int getRawDestinationIp() {
        return this.parent.getRawDestinationIp();
    }

    @Override
    public String getDestinationIP() {
        return this.parent.getDestinationIP();
    }

    @Override
    public String getSourceMacAddress() {
        return this.parent.getSourceMacAddress();
    }

    @Override
    public String getDestinationMacAddress() {
        return this.parent.getDestinationMacAddress();
    }

    @Override
    public void setSourceMacAddress(String macAddress) {
        this.parent.setSourceMacAddress(macAddress);
    }

    @Override
    public void setDestinationMacAddress(String macAddress) {
        this.parent.setDestinationMacAddress(macAddress);
    }

    @Override
    public void setSourceIP(int a, int b, int c, int d) {
        this.parent.setSourceIP(a, b, c, d);
    }

    @Override
    public void setDestinationIP(int a, int b, int c, int d) {
        this.parent.setDestinationIP(a, b, c, d);
    }

    @Override
    public void setSourceIP(String sourceIp) {
        this.parent.setSourceIP(sourceIp);
    }

    @Override
    public void setDestinationIP(String destinationIP) {
        this.parent.setDestinationIP(destinationIP);
    }

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("Seq=").append(this.getSeqNumber()).append(" type=").append(this.getPayloadType()).append(" src=").append(this.getSourceIP()).append(":").append(this.getSourcePort()).append(" dst=").append(this.getDestinationIP()).append(":").append(this.getDestinationPort());
            return sb.toString();
        }
        catch (IOException e) {
            return super.toString();
        }
    }

    @Override
    public byte[] dumpPacket() {
        int headerLength = this.headers.capacity();
        int payloadLength = this.payload.capacity();
        byte[] dump = new byte[headerLength + payloadLength];
        System.arraycopy(this.headers.getArray(), 0, dump, 0, headerLength);
        System.arraycopy(this.payload.getArray(), 0, dump, headerLength, payloadLength);
        return dump;
    }

    @Override
    public void write(OutputStream out, Buffer payload) throws IOException {
        throw new RuntimeException("Sorry, not implemented just yet.");
    }

    @Override
    public long getTotalLength() {
        return this.parent.getTotalLength();
    }

    @Override
    public int getIpChecksum() {
        return this.parent.getIpChecksum();
    }

    @Override
    public void setSourceIP(byte a, byte b, byte c, byte d) {
        this.parent.setSourceIP(a, b, c, d);
    }

    @Override
    public void setDestinationIP(byte a, byte b, byte c, byte d) {
        this.parent.setDestinationIP(a, b, c, d);
    }

    @Override
    public void reCalculateChecksum() {
        this.parent.reCalculateChecksum();
    }

    @Override
    public boolean verifyIpChecksum() {
        return this.parent.verifyIpChecksum();
    }

    @Override
    public RtpPacket clone() {
        throw new RuntimeException("Sorry, not implemented just yet");
    }

    @Override
    public void setSourcePort(int port) {
        this.parent.setSourcePort(port);
    }

    @Override
    public void setDestinationPort(int port) {
        this.parent.setDestinationPort(port);
    }

    @Override
    public int getTotalIPLength() {
        return 0;
    }

    @Override
    public int getHeaderLength() {
        return 0;
    }

    @Override
    public int getIdentification() {
        return this.parent.getIdentification();
    }

    @Override
    public boolean isFragmented() {
        return this.parent.isFragmented();
    }

    @Override
    public boolean isReservedFlagSet() {
        return this.parent.isReservedFlagSet();
    }

    @Override
    public boolean isDontFragmentSet() {
        return this.parent.isDontFragmentSet();
    }

    @Override
    public boolean isMoreFragmentsSet() {
        return this.parent.isMoreFragmentsSet();
    }

    @Override
    public short getFragmentOffset() {
        return this.parent.getFragmentOffset();
    }

    @Override
    public long getCapturedLength() {
        return 0L;
    }

    @Override
    public Packet getNextPacket() throws IOException {
        return null;
    }

    @Override
    public boolean isUDP() {
        return this.parent.isUDP();
    }

    @Override
    public boolean isTCP() {
        return this.parent.isTCP();
    }
}

