/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.Packet;
import io.pkts.packet.TransportPacket;
import io.pkts.packet.impl.AbstractPacket;
import io.pkts.packet.impl.SDPPacketImpl;
import io.pkts.packet.sip.SipMessage;
import io.pkts.packet.sip.SipPacket;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.SipRequestPacket;
import io.pkts.packet.sip.SipResponsePacket;
import io.pkts.packet.sip.header.CSeqHeader;
import io.pkts.packet.sip.header.CallIdHeader;
import io.pkts.packet.sip.header.ContactHeader;
import io.pkts.packet.sip.header.ContentTypeHeader;
import io.pkts.packet.sip.header.FromHeader;
import io.pkts.packet.sip.header.MaxForwardsHeader;
import io.pkts.packet.sip.header.RecordRouteHeader;
import io.pkts.packet.sip.header.RouteHeader;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.ToHeader;
import io.pkts.packet.sip.header.ViaHeader;
import io.pkts.protocol.Protocol;
import io.pkts.sdp.SDP;
import io.pkts.sdp.SDPFactory;
import io.pkts.sdp.SdpException;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.util.List;
import java.util.Optional;

public abstract class SipPacketImpl
extends AbstractPacket
implements SipPacket {
    private final TransportPacket parent;
    private final SipMessage msg;

    public SipPacketImpl(TransportPacket parent, SipMessage msg) {
        super(Protocol.SIP, parent, null);
        this.parent = parent;
        this.msg = msg;
    }

    protected TransportPacket getTransportPacket() {
        return this.parent;
    }

    protected SipMessage getSipMessage() {
        return this.msg;
    }

    @Override
    public int getSourcePort() {
        return this.parent.getSourcePort();
    }

    @Override
    public int getDestinationPort() {
        return this.parent.getDestinationPort();
    }

    @Override
    public int getRawSourceIp() {
        return this.parent.getRawSourceIp();
    }

    @Override
    public String getSourceIP() {
        return this.parent.getSourceIP();
    }

    @Override
    public void setSourceIP(int a, int b, int c, int d) {
        this.parent.setSourceIP(a, b, c, d);
    }

    @Override
    public void setSourceIP(byte a, byte b, byte c, byte d) {
        this.parent.setSourceIP(a, b, c, d);
    }

    @Override
    public void setSourceIP(String sourceIp) {
        this.parent.setSourceIP(sourceIp);
    }

    @Override
    public int getRawDestinationIp() {
        return this.parent.getRawDestinationIp();
    }

    @Override
    public String getDestinationIP() {
        return this.parent.getDestinationIP();
    }

    @Override
    public void setDestinationIP(int a, int b, int c, int d) {
        this.parent.setDestinationIP(a, b, c, d);
    }

    @Override
    public void setDestinationIP(byte a, byte b, byte c, byte d) {
        this.parent.setDestinationIP(a, b, c, d);
    }

    @Override
    public void setDestinationIP(String destinationIP) {
        this.parent.setDestinationIP(destinationIP);
    }

    @Override
    public long getTotalLength() {
        return this.parent.getTotalLength();
    }

    @Override
    public int getIpChecksum() {
        return this.parent.getIpChecksum();
    }

    @Override
    public void reCalculateChecksum() {
        this.parent.reCalculateChecksum();
    }

    @Override
    public boolean verifyIpChecksum() {
        return this.parent.verifyIpChecksum();
    }

    @Override
    public String getSourceMacAddress() {
        return this.parent.getSourceMacAddress();
    }

    @Override
    public void setSourceMacAddress(String macAddress) throws IllegalArgumentException {
        this.parent.setSourceMacAddress(macAddress);
    }

    @Override
    public String getDestinationMacAddress() {
        return this.parent.getDestinationMacAddress();
    }

    @Override
    public void setDestinationMacAddress(String macAddress) throws IllegalArgumentException {
        this.parent.setDestinationMacAddress(macAddress);
    }

    @Override
    public long getArrivalTime() {
        return this.parent.getArrivalTime();
    }

    @Override
    public void write(OutputStream out, Buffer payload) throws IOException {
        this.parent.write(out, Buffers.wrap((Buffer)this.msg.toBuffer(), (Buffer)payload));
    }

    @Override
    public Buffer getInitialLine() {
        return this.msg.getInitialLine();
    }

    @Override
    public SipRequestPacket toRequest() throws ClassCastException {
        throw new ClassCastException("Unable to cast this SipMessage into a SipRequest");
    }

    @Override
    public SipResponsePacket toResponse() throws ClassCastException {
        throw new ClassCastException("Unable to cast this SipMessage into a SipResponse");
    }

    @Override
    public boolean isResponse() {
        return this.msg.isResponse();
    }

    @Override
    public boolean isRequest() {
        return this.msg.isRequest();
    }

    @Override
    public Object getContent() throws SipParseException {
        return this.parseSipContent();
    }

    @Override
    public Buffer getRawContent() {
        return this.msg.getContent();
    }

    @Override
    public boolean hasContent() {
        return this.msg.hasContent();
    }

    @Override
    public Buffer getMethod() throws SipParseException {
        return this.msg.getMethod();
    }

    @Override
    public Optional<SipHeader> getHeader(Buffer headerName) throws SipParseException {
        return this.msg.getHeader(headerName);
    }

    @Override
    public Optional<SipHeader> getHeader(String headerName) throws SipParseException {
        return this.msg.getHeader(headerName);
    }

    @Override
    public void addHeader(SipHeader header) throws SipParseException {
        this.msg.addHeader(header);
    }

    @Override
    public void addHeaderFirst(SipHeader header) throws SipParseException {
        this.msg.addHeaderFirst(header);
    }

    @Override
    public void setHeader(SipHeader header) throws SipParseException {
        this.msg.setHeader(header);
    }

    @Override
    public FromHeader getFromHeader() throws SipParseException {
        return this.msg.getFromHeader();
    }

    @Override
    public ToHeader getToHeader() throws SipParseException {
        return this.msg.getToHeader();
    }

    @Override
    public ViaHeader getViaHeader() throws SipParseException {
        return this.msg.getViaHeader();
    }

    @Override
    public List<ViaHeader> getViaHeaders() throws SipParseException {
        return this.msg.getViaHeaders();
    }

    @Override
    public MaxForwardsHeader getMaxForwards() throws SipParseException {
        return this.msg.getMaxForwards();
    }

    @Override
    public RecordRouteHeader getRecordRouteHeader() throws SipParseException {
        return this.msg.getRecordRouteHeader();
    }

    @Override
    public List<RecordRouteHeader> getRecordRouteHeaders() throws SipParseException {
        return this.msg.getRecordRouteHeaders();
    }

    @Override
    public RouteHeader getRouteHeader() throws SipParseException {
        return this.msg.getRouteHeader();
    }

    @Override
    public List<RouteHeader> getRouteHeaders() throws SipParseException {
        return this.msg.getRouteHeaders();
    }

    @Override
    public ContactHeader getContactHeader() throws SipParseException {
        return this.msg.getContactHeader();
    }

    @Override
    public ContentTypeHeader getContentTypeHeader() throws SipParseException {
        return this.msg.getContentTypeHeader();
    }

    @Override
    public CallIdHeader getCallIDHeader() throws SipParseException {
        return this.msg.getCallIDHeader();
    }

    @Override
    public CSeqHeader getCSeqHeader() throws SipParseException {
        return this.msg.getCSeqHeader();
    }

    @Override
    public boolean isInvite() throws SipParseException {
        return this.msg.isInvite();
    }

    @Override
    public boolean isBye() throws SipParseException {
        return this.msg.isBye();
    }

    @Override
    public boolean isAck() throws SipParseException {
        return this.msg.isAck();
    }

    @Override
    public boolean isOptions() throws SipParseException {
        return this.msg.isOptions();
    }

    @Override
    public boolean isMessage() throws SipParseException {
        return this.msg.isMessage();
    }

    @Override
    public boolean isInfo() throws SipParseException {
        return this.msg.isInfo();
    }

    @Override
    public boolean isCancel() throws SipParseException {
        return this.msg.isCancel();
    }

    @Override
    public boolean isInitial() throws SipParseException {
        return this.msg.isInitial();
    }

    @Override
    public void verify() {
        this.msg.verify();
    }

    @Override
    public Buffer toBuffer() {
        return this.msg.toBuffer();
    }

    @Override
    public void setSourcePort(int port) {
        this.parent.setSourcePort(port);
    }

    @Override
    public void setDestinationPort(int port) {
        this.parent.setDestinationPort(port);
    }

    @Override
    public abstract SipPacket clone();

    @Override
    public long getCapturedLength() {
        return 0L;
    }

    private Object parseSipContent() {
        try {
            Buffer content = this.msg.getContent();
            ContentTypeHeader contentType = this.getContentTypeHeader();
            if (content != null && contentType.isSDP()) {
                return SDPFactory.getInstance().parse(content);
            }
        }
        catch (SipParseException | SdpException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Packet getNextPacket() throws IOException {
        Object content = this.parseSipContent();
        if (content instanceof SDP) {
            return new SDPPacketImpl(this, (SDP)content);
        }
        return null;
    }

    @Override
    public Buffer getPayload() {
        return this.msg.getContent();
    }

    @Override
    public int getTotalIPLength() {
        return this.parent.getTotalIPLength();
    }

    @Override
    public int getVersion() {
        return this.parent.getVersion();
    }

    @Override
    public int getHeaderLength() {
        return this.parent.getHeaderLength();
    }

    @Override
    public int getIdentification() {
        return this.parent.getIdentification();
    }

    @Override
    public boolean isFragmented() {
        return this.parent.isFragmented();
    }

    @Override
    public boolean isReservedFlagSet() {
        return this.parent.isReservedFlagSet();
    }

    @Override
    public boolean isDontFragmentSet() {
        return this.parent.isDontFragmentSet();
    }

    @Override
    public boolean isMoreFragmentsSet() {
        return this.parent.isMoreFragmentsSet();
    }

    @Override
    public short getFragmentOffset() {
        return this.parent.getFragmentOffset();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isUDP()) {
            sb.append("U ");
        } else if (this.isTCP()) {
            sb.append("T ");
        }
        Instant timestamp = Instant.ofEpochMilli(this.getArrivalTime() / 1000L);
        sb.append(timestamp.toString()).append(" ").append(this.getSourceIP()).append(":").append(this.getSourcePort()).append(" -> ").append(this.getDestinationIP()).append(":").append(this.getDestinationPort()).append("\n").append(this.msg.toString());
        return sb.toString();
    }

    @Override
    public boolean isUDP() {
        return this.parent.isUDP();
    }

    @Override
    public boolean isTCP() {
        return this.parent.isTCP();
    }
}

