/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.frame;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.frame.PcapGlobalHeader;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;

public final class PcapRecordHeader {
    public static final int SIZE = 16;
    private final ByteOrder byteOrder;
    private final Buffer body;

    public PcapRecordHeader(ByteOrder byteOrder, Buffer body) {
        assert (body != null);
        assert (body.capacity() == 16);
        this.byteOrder = byteOrder;
        this.body = body;
    }

    public static PcapRecordHeader createDefaultHeader(long timestamp) {
        byte[] body = new byte[16];
        Buffer buffer = Buffers.wrap((byte[])body);
        buffer.setUnsignedInt(0, timestamp / 1000L);
        buffer.setUnsignedInt(4, timestamp % 1000L * 1000L);
        return new PcapRecordHeader(ByteOrder.LITTLE_ENDIAN, buffer);
    }

    public long getTimeStampSeconds() {
        return PcapGlobalHeader.getUnsignedInt(0, this.body.getArray(), this.byteOrder);
    }

    public long getTimeStampMicroSeconds() {
        return PcapGlobalHeader.getUnsignedInt(4, this.body.getArray(), this.byteOrder);
    }

    public long getTotalLength() {
        return PcapGlobalHeader.getUnsignedInt(12, this.body.getArray(), this.byteOrder);
    }

    public void setTotalLength(long length) {
        this.body.setUnsignedInt(12, length);
    }

    public long getCapturedLength() {
        return PcapGlobalHeader.getUnsignedInt(8, this.body.getArray(), this.byteOrder);
    }

    public void setCapturedLength(long length) {
        this.body.setUnsignedInt(8, length);
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.body.getArray());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        long ts = this.getTimeStampSeconds();
        long tsMicroSeconds = this.getTimeStampMicroSeconds();
        sb.append("ts_s: ").append(ts).append("\n").append("ts_us: ").append(tsMicroSeconds).append("\n").append("octects: ").append(this.getTotalLength()).append("\n").append("length: ").append(this.getCapturedLength()).append("\n");
        return sb.toString();
    }
}

