/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.SipRequest;
import io.pkts.packet.sip.SipResponse;
import io.pkts.packet.sip.address.SipURI;
import io.pkts.packet.sip.header.AddressParametersHeader;
import io.pkts.packet.sip.header.CSeqHeader;
import io.pkts.packet.sip.header.CallIdHeader;
import io.pkts.packet.sip.header.ContactHeader;
import io.pkts.packet.sip.header.ContentTypeHeader;
import io.pkts.packet.sip.header.ExpiresHeader;
import io.pkts.packet.sip.header.FromHeader;
import io.pkts.packet.sip.header.MaxForwardsHeader;
import io.pkts.packet.sip.header.RecordRouteHeader;
import io.pkts.packet.sip.header.RouteHeader;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.ToHeader;
import io.pkts.packet.sip.header.ViaHeader;
import io.pkts.packet.sip.impl.PreConditions;
import io.pkts.packet.sip.impl.SipInitialLine;
import io.pkts.packet.sip.impl.SipParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public interface SipMessage
extends Cloneable {
    public static final String UNABLE_TO_PARSE_OUT_THE_METHOD_DUE_TO_UNDERLYING_IO_EXCEPTION = "Unable to parse out the method due to underlying IOException";

    public Buffer getInitialLine();

    default public SipInitialLine initialLine() {
        return null;
    }

    default public SipRequest toRequest() throws ClassCastException {
        throw new ClassCastException("Unable to cast a " + this.getClass().getName() + " into a " + SipRequest.class.getName());
    }

    default public SipResponse toResponse() throws ClassCastException {
        throw new ClassCastException("Unable to cast a " + this.getClass().getName() + " into a " + SipResponse.class.getName());
    }

    default public SipResponse.Builder createResponse(int responseCode) throws SipParseException, ClassCastException {
        return this.createResponse(responseCode, null);
    }

    default public SipResponse.Builder createResponse(int responseCode, Buffer content) throws SipParseException, ClassCastException {
        throw new ClassCastException("Unable to cast this SipMessage into a SipRequest");
    }

    default public boolean isResponse() {
        return false;
    }

    default public boolean isRequest() {
        return false;
    }

    public Buffer getContent();

    public boolean hasContent();

    public Buffer getMethod() throws SipParseException;

    public Optional<SipHeader> getHeader(Buffer var1) throws SipParseException;

    public Optional<SipHeader> getHeader(String var1) throws SipParseException;

    public List<SipHeader> getHeaders(String var1) throws SipParseException;

    public List<SipHeader> getHeaders(Buffer var1) throws SipParseException;

    public void addHeader(SipHeader var1) throws SipParseException;

    public void addHeaderFirst(SipHeader var1) throws SipParseException;

    public SipHeader popHeader(Buffer var1) throws SipParseException;

    public void setHeader(SipHeader var1) throws SipParseException;

    public FromHeader getFromHeader() throws SipParseException;

    public ToHeader getToHeader() throws SipParseException;

    public ViaHeader getViaHeader() throws SipParseException;

    public List<ViaHeader> getViaHeaders() throws SipParseException;

    public MaxForwardsHeader getMaxForwards() throws SipParseException;

    public RecordRouteHeader getRecordRouteHeader() throws SipParseException;

    public List<RecordRouteHeader> getRecordRouteHeaders() throws SipParseException;

    public RouteHeader getRouteHeader() throws SipParseException;

    public List<RouteHeader> getRouteHeaders() throws SipParseException;

    public ExpiresHeader getExpiresHeader() throws SipParseException;

    public ContactHeader getContactHeader() throws SipParseException;

    public ContentTypeHeader getContentTypeHeader() throws SipParseException;

    public int getContentLength() throws SipParseException;

    public CallIdHeader getCallIDHeader() throws SipParseException;

    public CSeqHeader getCSeqHeader() throws SipParseException;

    default public boolean isInvite() throws SipParseException {
        Buffer m = this.getMethod();
        try {
            return m.getByte(0) == 73 && m.getByte(1) == 78 && m.getByte(2) == 86 && m.getByte(3) == 73 && m.getByte(4) == 84 && m.getByte(5) == 69;
        }
        catch (IOException e) {
            throw new SipParseException(0, UNABLE_TO_PARSE_OUT_THE_METHOD_DUE_TO_UNDERLYING_IO_EXCEPTION, e);
        }
    }

    default public boolean isRegister() throws SipParseException {
        Buffer m = this.getMethod();
        try {
            return m.getByte(0) == 82 && m.getByte(1) == 69 && m.getByte(2) == 71 && m.getByte(3) == 73 && m.getByte(4) == 83 && m.getByte(5) == 84 && m.getByte(6) == 69 && m.getByte(7) == 82;
        }
        catch (IOException e) {
            throw new SipParseException(0, UNABLE_TO_PARSE_OUT_THE_METHOD_DUE_TO_UNDERLYING_IO_EXCEPTION, e);
        }
    }

    default public boolean isBye() throws SipParseException {
        Buffer m = this.getMethod();
        try {
            return m.getByte(0) == 66 && m.getByte(1) == 89 && m.getByte(2) == 69;
        }
        catch (IOException e) {
            throw new SipParseException(0, UNABLE_TO_PARSE_OUT_THE_METHOD_DUE_TO_UNDERLYING_IO_EXCEPTION, e);
        }
    }

    default public boolean isAck() throws SipParseException {
        Buffer m = this.getMethod();
        try {
            return m.getByte(0) == 65 && m.getByte(1) == 67 && m.getByte(2) == 75;
        }
        catch (IOException e) {
            throw new SipParseException(0, UNABLE_TO_PARSE_OUT_THE_METHOD_DUE_TO_UNDERLYING_IO_EXCEPTION, e);
        }
    }

    default public boolean isCancel() throws SipParseException {
        Buffer m = this.getMethod();
        try {
            return m.getByte(0) == 67 && m.getByte(1) == 65 && m.getByte(2) == 78 && m.getByte(3) == 67 && m.getByte(4) == 69 && m.getByte(5) == 76;
        }
        catch (IOException e) {
            throw new SipParseException(0, UNABLE_TO_PARSE_OUT_THE_METHOD_DUE_TO_UNDERLYING_IO_EXCEPTION, e);
        }
    }

    default public boolean isOptions() throws SipParseException {
        Buffer m = this.getMethod();
        try {
            return m.getByte(0) == 79 && m.getByte(1) == 80 && m.getByte(2) == 84 && m.getByte(3) == 73 && m.getByte(4) == 79 && m.getByte(5) == 78 && m.getByte(6) == 83;
        }
        catch (IOException e) {
            throw new SipParseException(0, UNABLE_TO_PARSE_OUT_THE_METHOD_DUE_TO_UNDERLYING_IO_EXCEPTION, e);
        }
    }

    default public boolean isMessage() throws SipParseException {
        Buffer m = this.getMethod();
        try {
            return m.getByte(0) == 77 && m.getByte(1) == 69 && m.getByte(2) == 83 && m.getByte(3) == 83 && m.getByte(4) == 65 && m.getByte(5) == 71 && m.getByte(6) == 69;
        }
        catch (IOException e) {
            throw new SipParseException(0, UNABLE_TO_PARSE_OUT_THE_METHOD_DUE_TO_UNDERLYING_IO_EXCEPTION, e);
        }
    }

    default public boolean isInfo() throws SipParseException {
        Buffer m = this.getMethod();
        try {
            return m.getByte(0) == 73 && m.getByte(1) == 78 && m.getByte(2) == 70 && m.getByte(3) == 79;
        }
        catch (IOException e) {
            throw new SipParseException(0, UNABLE_TO_PARSE_OUT_THE_METHOD_DUE_TO_UNDERLYING_IO_EXCEPTION, e);
        }
    }

    public boolean isInitial() throws SipParseException;

    default public boolean isSubsequent() throws SipParseException {
        return !this.isInitial();
    }

    public void verify();

    public Buffer toBuffer();

    public SipMessage clone();

    public static SipMessage frame(Buffer buffer) throws SipParseException, IOException {
        PreConditions.assertNotNull(buffer);
        return SipParser.frame(buffer);
    }

    public static SipMessage frame(String buffer) throws SipParseException, IOException {
        PreConditions.assertNotEmpty(buffer, "Buffer cannot be null or the empty string");
        return SipParser.frame(Buffers.wrap((String)buffer));
    }

    public static SipMessage frame(byte[] buffer) throws SipParseException, IOException {
        PreConditions.assertNotNull(buffer, "Byte-array cannot be null");
        return SipParser.frame(Buffers.wrap((byte[])buffer));
    }

    default public int countNoOfHeaders() {
        return this.getAllHeaders().size();
    }

    default public List<SipHeader> getAllHeaders() {
        return new ArrayList<SipHeader>();
    }

    public Builder<? extends SipMessage> copy();

    public static interface Builder<T extends SipMessage> {
        default public boolean isSipRequestBuilder() {
            return false;
        }

        default public boolean isSipResponseBuilder() {
            return false;
        }

        default public Builder<SipRequest> toSipRequestBuilder() {
            throw new ClassCastException("Cannot cast " + this.getClass().getName() + " into a SipRequest builder");
        }

        default public Builder<SipResponse> toSipResponseBuilder() {
            throw new ClassCastException("Cannot cast " + this.getClass().getName() + " into a SipResponse builder");
        }

        public Builder<T> withNoDefaults();

        public Builder<T> onHeader(Function<SipHeader, SipHeader> var1) throws IllegalStateException;

        public Builder<T> withHeader(SipHeader var1);

        public Builder<T> withHeaders(List<SipHeader> var1);

        public Builder<T> withPushHeader(SipHeader var1);

        public Builder<T> onFromHeader(Consumer<AddressParametersHeader.Builder<FromHeader>> var1);

        public Builder<T> withFromHeader(FromHeader var1);

        public Builder<T> withFromHeader(String var1);

        public Builder<T> onToHeader(Consumer<AddressParametersHeader.Builder<ToHeader>> var1);

        public Builder<T> withToHeader(ToHeader var1);

        public Builder<T> withToHeader(String var1);

        public Builder<T> onContactHeader(Consumer<AddressParametersHeader.Builder<ContactHeader>> var1);

        public Builder<T> withContactHeader(ContactHeader var1);

        public Builder<T> onCSeqHeader(Consumer<CSeqHeader.Builder> var1);

        public Builder<T> withCSeqHeader(CSeqHeader var1);

        public Builder<T> onMaxForwardsHeader(Consumer<MaxForwardsHeader.Builder> var1);

        public Builder<T> withMaxForwardsHeader(MaxForwardsHeader var1);

        public Builder<T> withCallIdHeader(CallIdHeader var1);

        public Builder<T> onTopMostRouteHeader(Consumer<AddressParametersHeader.Builder<RouteHeader>> var1);

        public Builder<T> onRouteHeader(Consumer<AddressParametersHeader.Builder<RouteHeader>> var1);

        public Builder<T> withRouteHeader(RouteHeader var1);

        public Builder<T> withRouteHeaders(RouteHeader ... var1);

        public Builder<T> withRouteHeaders(List<RouteHeader> var1);

        public Builder<T> withTopMostRouteHeader(RouteHeader var1);

        public Builder<T> withPoppedRoute();

        public Builder<T> withNoRoutes();

        public Builder<T> onTopMostRecordRouteHeader(Consumer<AddressParametersHeader.Builder<RecordRouteHeader>> var1);

        public Builder<T> onRecordRouteHeader(Consumer<AddressParametersHeader.Builder<RecordRouteHeader>> var1);

        public Builder<T> withRecordRouteHeader(RecordRouteHeader var1);

        public Builder<T> withRecordRouteHeaders(RecordRouteHeader ... var1);

        public Builder<T> withRecordRouteHeaders(List<RecordRouteHeader> var1);

        public Builder<T> withTopMostRecordRouteHeader(RecordRouteHeader var1);

        public Builder<T> onRequestURI(Function<SipURI, SipURI> var1);

        public Builder<T> onTopMostViaHeader(Consumer<ViaHeader.Builder> var1);

        public Builder<T> onViaHeader(BiConsumer<Integer, ViaHeader.Builder> var1);

        public Builder<T> withViaHeader(ViaHeader var1);

        public Builder<T> withViaHeaders(ViaHeader ... var1);

        public Builder<T> withViaHeaders(List<ViaHeader> var1);

        public Builder<T> withTopMostViaHeader(ViaHeader var1);

        public Builder<T> withTopMostViaHeader();

        public Builder<T> withPoppedVia();

        public Builder<T> withBody(Buffer var1);

        public T build();

        public Builder<T> onCommit(Consumer<SipMessage> var1);
    }
}

