/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.header.Parameters;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.impl.ViaHeaderImpl;
import io.pkts.packet.sip.impl.PreConditions;
import io.pkts.packet.sip.impl.SipParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public interface ViaHeader
extends Parameters,
SipHeader {
    public static final Buffer NAME = Buffers.wrap((String)"Via");
    public static final Buffer COMPACT_NAME = Buffers.wrap((String)"v");

    public Buffer getTransport();

    public Buffer getHost();

    public int getPort();

    public Buffer getReceived();

    @Override
    default public ViaHeader toViaHeader() {
        return this;
    }

    @Override
    default public boolean isViaHeader() {
        return true;
    }

    public boolean hasRPort();

    public int getRPort();

    public Buffer getBranch();

    public int getTTL();

    public boolean isUDP();

    public boolean isTCP();

    public boolean isTLS();

    public boolean isSCTP();

    @Override
    public ViaHeader clone();

    @Override
    public Builder copy();

    public static ViaHeader frame(Buffer buffer) throws SipParseException {
        try {
            return new Builder(buffer).build();
        }
        catch (IOException e) {
            throw new SipParseException(0, "Unable to frame the Via header due to IOException", e);
        }
    }

    public static Buffer generateBranch() {
        return Buffers.wrap((String)("z9hG4bK-" + UUID.randomUUID().toString()));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder withHost(Buffer host) {
        Builder builder = new Builder();
        return builder.withHost(host);
    }

    public static Builder withHost(String host) {
        Builder builder = new Builder();
        return builder.withHost(host);
    }

    public static class Builder
    implements SipHeader.Builder<ViaHeader> {
        private static final Buffer udp = Buffers.wrap((String)"UDP");
        private static final Buffer tcp = Buffers.wrap((String)"TCP");
        private static final Buffer tls = Buffers.wrap((String)"TLS");
        private static final Buffer sctp = Buffers.wrap((String)"SCTP");
        private static final Buffer ws = Buffers.wrap((String)"WS");
        private static final Buffer wss = Buffers.wrap((String)"WSS");
        private static final Buffer BRANCH = Buffers.wrap((String)"branch");
        private static final Buffer RECEIVED = Buffers.wrap((String)"received");
        private static final Buffer RPORT = Buffers.wrap((String)"rport");
        private static final Buffer TTL = Buffers.wrap((String)"ttl");
        private int indexOfBranch;
        private int indexOfReceived;
        private int indexOfRPort;
        private Buffer transport;
        private Buffer host;
        private int port;
        private List<Buffer[]> params;
        private Buffer branch;

        public Builder() {
            this.params = new ArrayList<Buffer[]>(3);
            this.port = -1;
            this.indexOfBranch = -1;
            this.indexOfReceived = -1;
            this.indexOfRPort = -1;
        }

        public Builder(Buffer transport, Buffer host, int port, List<Buffer[]> params, int indexOfBranch, int indexOfReceived, int indexOfRPort) {
            this.transport = transport;
            this.host = host;
            this.port = port;
            this.params = params;
            this.indexOfBranch = indexOfBranch;
            this.indexOfReceived = indexOfReceived;
            this.indexOfRPort = indexOfRPort;
        }

        public Builder(Buffer buffer) throws IOException {
            try {
                Object[] result = SipParser.consumeVia(buffer);
                this.transport = (Buffer)result[0];
                this.host = (Buffer)result[1];
                this.port = result[2] == null ? -1 : ((Buffer)result[2]).parseToInt();
                this.params = (List)result[3];
                this.indexOfBranch = this.findParameter(BRANCH);
                this.indexOfReceived = this.findParameter(RECEIVED);
                this.indexOfRPort = this.findParameter(RPORT);
            }
            catch (IOException e) {
                throw new SipParseException(0, "Unable to frame the Via header due to IOException", e);
            }
        }

        private int findParameter(Buffer param) {
            for (int i = 0; i < this.params.size(); ++i) {
                Buffer[] keyValue = this.params.get(i);
                if (!keyValue[0].equals((Object)param)) continue;
                return i;
            }
            return -1;
        }

        public Builder withParameter(Buffer name, Buffer value) throws SipParseException, IllegalArgumentException {
            int index = this.findParameter(name);
            if (index == -1) {
                this.params.add(new Buffer[]{name, value});
            } else {
                this.params.get((int)index)[1] = value;
            }
            return this;
        }

        public Builder withParameter(String name, String value) throws SipParseException, IllegalArgumentException {
            return this.withParameter(Buffers.wrap((String)name), Buffers.wrap((String)value));
        }

        public Builder withPort(int port) {
            PreConditions.assertArgument(port > 0, "Port must be greater than zero");
            this.port = port;
            return this;
        }

        public Builder withHost(Buffer host) {
            this.host = PreConditions.assertNotEmpty(host, "Host cannot be empty or null");
            return this;
        }

        public Builder withHost(String host) {
            PreConditions.assertNotEmpty(host, "Host cannot be empty or null");
            this.host = Buffers.wrap((String)host);
            return this;
        }

        public Builder withBranch() {
            return this.withBranch(ViaHeader.generateBranch());
        }

        public Builder withBranch(Buffer branch) {
            PreConditions.assertNotEmpty(branch, "Branch cannot be empty or null.");
            if (this.indexOfBranch == -1) {
                this.indexOfBranch = this.findParameter(BRANCH);
            }
            if (this.indexOfBranch == -1) {
                this.indexOfBranch = this.params.size();
                this.params.add(new Buffer[]{BRANCH, branch});
            } else {
                this.params.get((int)this.indexOfBranch)[1] = branch;
            }
            return this;
        }

        public Builder withBranch(String branch) {
            PreConditions.assertNotEmpty(branch, "Branch cannot be empty or null.");
            this.withBranch(Buffers.wrap((String)branch));
            return this;
        }

        public Builder withRPortFlag() {
            return this.setRPort(-1);
        }

        public boolean hasRPort() {
            if (this.indexOfRPort != -1) {
                return true;
            }
            this.indexOfRPort = this.findParameter(RPORT);
            return this.indexOfRPort != -1;
        }

        public Builder withRPort(int rport) {
            return this.setRPort(rport);
        }

        private Builder setRPort(int rport) {
            Buffer rportBuffer;
            if (this.indexOfRPort == -1) {
                this.indexOfRPort = this.findParameter(RPORT);
            }
            Buffer buffer = rportBuffer = rport == -1 ? null : Buffers.wrap((int)rport);
            if (this.indexOfRPort == -1) {
                this.indexOfRPort = this.params.size();
                this.params.add(new Buffer[]{RPORT, rportBuffer});
            } else {
                this.params.get((int)this.indexOfRPort)[1] = rportBuffer;
            }
            return this;
        }

        public Builder withReceived(String received) {
            return this.withReceived(Buffers.wrap((String)received));
        }

        public Builder withReceived(Buffer received) {
            if (this.indexOfReceived == -1) {
                this.indexOfReceived = this.findParameter(RECEIVED);
            }
            if (this.indexOfReceived == -1) {
                this.indexOfReceived = this.params.size();
                this.params.add(new Buffer[]{RECEIVED, received});
            } else {
                this.params.get((int)this.indexOfReceived)[1] = received;
            }
            return this;
        }

        public Builder withTransportUDP() {
            this.transport = udp.clone();
            return this;
        }

        public Builder withTransportSCTP() {
            this.transport = sctp.clone();
            return this;
        }

        public Builder withTransportTCP() {
            this.transport = tcp.clone();
            return this;
        }

        public Builder withTransportTLS() {
            this.transport = tls.clone();
            return this;
        }

        public Builder withTransportWS() {
            this.transport = ws.clone();
            return this;
        }

        public Builder withTransportWSS() {
            this.transport = wss.clone();
            return this;
        }

        public Builder withTransport(Buffer transport) throws SipParseException {
            PreConditions.assertNotNull(transport);
            if (SipParser.isUDP(transport) || SipParser.isTCP(transport) || SipParser.isTLS(transport) || SipParser.isWS(transport) || SipParser.isSCTP(transport)) {
                this.transport = transport.clone();
                return this;
            }
            throw new SipParseException(0, "Illegal transport");
        }

        public Builder withTransport(String transport) throws SipParseException {
            return this.withTransport(Buffers.wrap((String)transport));
        }

        @Override
        public SipHeader.Builder<ViaHeader> withValue(Buffer value) {
            throw new RuntimeException("TODO: not implemented yet");
        }

        @Override
        public ViaHeader build() throws SipParseException {
            if (this.indexOfBranch == -1) {
                throw new SipParseException("You must specify a branch parameter");
            }
            if (this.transport == null) {
                this.transport = udp.clone();
            }
            if (this.host == null) {
                throw new SipParseException("You must specify the host of the Via-header");
            }
            Buffer via = Buffers.createBuffer((int)1024);
            this.transferValue(via);
            return new ViaHeaderImpl(via, this.transport, this.host, this.port, this.params, this.indexOfBranch, this.indexOfReceived, this.indexOfRPort);
        }

        private void transferValue(Buffer dst) {
            SipParser.SIP2_0_SLASH.getBytes(0, dst);
            this.transport.getBytes(0, dst);
            dst.write((byte)32);
            this.host.getBytes(0, dst);
            if (this.port != -1) {
                dst.write((byte)58);
                dst.writeAsString(this.port);
            }
            for (Buffer[] param : this.params) {
                dst.write((byte)59);
                param[0].getBytes(0, dst);
                if (param[1] == null) continue;
                dst.write((byte)61);
                param[1].getBytes(0, dst);
            }
        }
    }
}

