/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipMessage;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.header.CSeqHeader;
import io.pkts.packet.sip.header.CallIdHeader;
import io.pkts.packet.sip.header.ContactHeader;
import io.pkts.packet.sip.header.ContentLengthHeader;
import io.pkts.packet.sip.header.ContentTypeHeader;
import io.pkts.packet.sip.header.ExpiresHeader;
import io.pkts.packet.sip.header.FromHeader;
import io.pkts.packet.sip.header.MaxForwardsHeader;
import io.pkts.packet.sip.header.RecordRouteHeader;
import io.pkts.packet.sip.header.RouteHeader;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.ToHeader;
import io.pkts.packet.sip.header.ViaHeader;
import io.pkts.packet.sip.impl.PreConditions;
import io.pkts.packet.sip.impl.SipInitialLine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public abstract class ImmutableSipMessage
implements SipMessage {
    private static final String I_AM_IMMUTABLE_NO_CAN_DO = "I am immutable, no can do";
    private final Buffer message;
    private final SipInitialLine initialLine;
    private final List<SipHeader> headers;
    private final Buffer body;
    private final short indexOfTo;
    private final short indexOfFrom;
    private final short indexOfCSeq;
    private final short indexOfCallId;
    private final short indexOfMaxForwards;
    private final short indexOfVia;
    private final short indexOfRoute;
    private final short indexOfRecordRoute;
    private final short indexOfContact;

    protected ImmutableSipMessage(Buffer message, SipInitialLine initialLine, List<SipHeader> headers, short indexOfTo, short indexOfFrom, short indexOfCSeq, short indexOfCallId, short indexOfMaxForwards, short indexOfVia, short indexOfRoute, short indexOfRecordRoute, short indexOfContact, Buffer body) {
        this.message = message;
        this.initialLine = initialLine;
        this.headers = headers;
        this.body = body;
        this.indexOfTo = indexOfTo;
        this.indexOfFrom = indexOfFrom;
        this.indexOfCSeq = indexOfCSeq;
        this.indexOfCallId = indexOfCallId;
        this.indexOfMaxForwards = indexOfMaxForwards;
        this.indexOfVia = indexOfVia;
        this.indexOfRoute = indexOfRoute;
        this.indexOfRecordRoute = indexOfRecordRoute;
        this.indexOfContact = indexOfContact;
    }

    @Override
    public SipInitialLine initialLine() {
        return this.initialLine;
    }

    public String toString() {
        return this.message.toString();
    }

    @Override
    public List<SipHeader> getAllHeaders() {
        return new ArrayList<SipHeader>(this.headers);
    }

    @Override
    public int countNoOfHeaders() {
        return this.headers.size();
    }

    @Override
    public Buffer getInitialLine() {
        return this.initialLine.getBuffer();
    }

    protected SipInitialLine getInitialLineAsObject() {
        return this.initialLine;
    }

    @Override
    public Buffer getContent() {
        return this.body;
    }

    @Override
    public boolean hasContent() {
        return this.body != null;
    }

    @Override
    public Optional<SipHeader> getHeader(Buffer headerName) throws SipParseException {
        return Optional.ofNullable(this.findHeader(headerName));
    }

    @Override
    public List<SipHeader> getHeaders(Buffer headerName) throws SipParseException {
        PreConditions.assertNotEmpty(headerName, "The name of the header cannot be null or the empty buffer");
        return this.getHeadersInternal(headerName);
    }

    @Override
    public List<SipHeader> getHeaders(String headerName) throws SipParseException {
        PreConditions.assertNotEmpty(headerName, "The name of the header cannot be null or the empty string");
        return this.getHeadersInternal(Buffers.wrap((String)headerName));
    }

    private List<SipHeader> getHeadersInternal(Buffer headerName) {
        ArrayList<SipHeader> headers = new ArrayList<SipHeader>(3);
        for (SipHeader header : this.headers) {
            if (!headerName.equals((Object)header.getName())) continue;
            headers.add(header);
        }
        return headers;
    }

    @Override
    public Optional<SipHeader> getHeader(String headerName) throws SipParseException {
        return Optional.ofNullable(this.findHeader(Buffers.wrap((String)headerName)));
    }

    @Override
    public void addHeader(SipHeader header) throws SipParseException {
        throw new RuntimeException(I_AM_IMMUTABLE_NO_CAN_DO);
    }

    @Override
    public void addHeaderFirst(SipHeader header) throws SipParseException {
        throw new RuntimeException(I_AM_IMMUTABLE_NO_CAN_DO);
    }

    @Override
    public SipHeader popHeader(Buffer headerNme) throws SipParseException {
        throw new RuntimeException(I_AM_IMMUTABLE_NO_CAN_DO);
    }

    @Override
    public void setHeader(SipHeader header) throws SipParseException {
        throw new RuntimeException(I_AM_IMMUTABLE_NO_CAN_DO);
    }

    @Override
    public FromHeader getFromHeader() throws SipParseException {
        if (this.indexOfFrom != -1) {
            return this.headers.get(this.indexOfFrom).ensure().toFromHeader();
        }
        return null;
    }

    @Override
    public ToHeader getToHeader() throws SipParseException {
        if (this.indexOfTo != -1) {
            return this.headers.get(this.indexOfTo).ensure().toToHeader();
        }
        return null;
    }

    @Override
    public ViaHeader getViaHeader() throws SipParseException {
        if (this.indexOfVia != -1) {
            return this.headers.get(this.indexOfVia).ensure().toViaHeader();
        }
        return null;
    }

    @Override
    public List<ViaHeader> getViaHeaders() throws SipParseException {
        if (this.indexOfVia == -1) {
            return Collections.emptyList();
        }
        ArrayList<ViaHeader> vias = new ArrayList<ViaHeader>(5);
        vias.add(this.headers.get(this.indexOfVia).ensure().toViaHeader());
        for (int i = this.indexOfVia + 1; i < this.headers.size(); ++i) {
            SipHeader h = this.headers.get(i);
            if (!h.isViaHeader()) continue;
            vias.add(h.ensure().toViaHeader());
        }
        return vias;
    }

    @Override
    public MaxForwardsHeader getMaxForwards() throws SipParseException {
        if (this.indexOfMaxForwards != -1) {
            return this.headers.get(this.indexOfMaxForwards).ensure().toMaxForwardsHeader();
        }
        return null;
    }

    @Override
    public RecordRouteHeader getRecordRouteHeader() throws SipParseException {
        if (this.indexOfRecordRoute != -1) {
            return this.headers.get(this.indexOfRecordRoute).ensure().toRecordRouteHeader();
        }
        return null;
    }

    @Override
    public List<RecordRouteHeader> getRecordRouteHeaders() throws SipParseException {
        if (this.indexOfRecordRoute == -1) {
            return Collections.emptyList();
        }
        ArrayList<RecordRouteHeader> routes = new ArrayList<RecordRouteHeader>(5);
        routes.add(this.headers.get(this.indexOfRecordRoute).ensure().toRecordRouteHeader());
        for (int i = this.indexOfRecordRoute + 1; i < this.headers.size(); ++i) {
            SipHeader h = this.headers.get(i);
            if (!h.isRecordRouteHeader()) continue;
            routes.add(h.ensure().toRecordRouteHeader());
        }
        return routes;
    }

    @Override
    public RouteHeader getRouteHeader() throws SipParseException {
        if (this.indexOfRoute != -1) {
            return this.headers.get(this.indexOfRoute).ensure().toRouteHeader();
        }
        return null;
    }

    @Override
    public List<RouteHeader> getRouteHeaders() throws SipParseException {
        if (this.indexOfRoute == -1) {
            return Collections.emptyList();
        }
        ArrayList<RouteHeader> routes = new ArrayList<RouteHeader>(5);
        routes.add(this.headers.get(this.indexOfRoute).ensure().toRouteHeader());
        for (int i = this.indexOfRoute + 1; i < this.headers.size(); ++i) {
            SipHeader h = this.headers.get(i);
            if (!h.isRouteHeader()) continue;
            routes.add(h.ensure().toRouteHeader());
        }
        return routes;
    }

    @Override
    public ExpiresHeader getExpiresHeader() throws SipParseException {
        SipHeader header = this.findHeader(ExpiresHeader.NAME);
        if (header == null) {
            return null;
        }
        return header.ensure().toExpiresHeader();
    }

    @Override
    public ContactHeader getContactHeader() throws SipParseException {
        if (this.indexOfContact != -1) {
            return this.headers.get(this.indexOfContact).ensure().toContactHeader();
        }
        return null;
    }

    @Override
    public ContentTypeHeader getContentTypeHeader() throws SipParseException {
        SipHeader header = this.findHeader(ContentTypeHeader.NAME);
        if (header == null) {
            return null;
        }
        return header.ensure().toContentTypeHeader();
    }

    @Override
    public int getContentLength() throws SipParseException {
        SipHeader header = this.findHeader(ContentLengthHeader.NAME);
        if (header == null) {
            return 0;
        }
        return header.ensure().toContentLengthHeader().getContentLength();
    }

    @Override
    public CallIdHeader getCallIDHeader() throws SipParseException {
        if (this.indexOfCallId != -1) {
            return this.headers.get(this.indexOfCallId).ensure().toCallIdHeader();
        }
        return null;
    }

    @Override
    public CSeqHeader getCSeqHeader() throws SipParseException {
        if (this.indexOfCSeq != -1) {
            return this.headers.get(this.indexOfCSeq).ensure().toCSeqHeader();
        }
        return null;
    }

    @Override
    public boolean isInitial() throws SipParseException {
        ToHeader to = this.getToHeader();
        return to.getTag() == null;
    }

    @Override
    public void verify() {
    }

    private SipHeader findHeader(Buffer name) {
        for (SipHeader header : this.headers) {
            if (!name.equals((Object)header.getName())) continue;
            return header;
        }
        return null;
    }

    @Override
    public Buffer toBuffer() {
        return this.message;
    }

    @Override
    public SipMessage clone() {
        return this;
    }
}

