/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.address.SipURI;
import io.pkts.packet.sip.address.URI;
import io.pkts.packet.sip.impl.SipInitialLine;
import io.pkts.packet.sip.impl.SipParser;
import java.io.IOException;

public final class SipRequestLine
extends SipInitialLine {
    private final Buffer method;
    private final Buffer requestUriBuffer;
    private URI requestURI;

    public SipRequestLine(Buffer method, Buffer requestUri) {
        assert (method != null);
        assert (requestUri != null);
        this.method = method;
        this.requestUriBuffer = requestUri;
    }

    public SipRequestLine(Buffer method, URI requestUri) {
        assert (method != null);
        assert (requestUri != null);
        this.method = method;
        this.requestUriBuffer = null;
        this.requestURI = requestUri;
    }

    @Override
    public boolean isRequestLine() {
        return true;
    }

    @Override
    public SipRequestLine toRequestLine() {
        return this;
    }

    public Buffer getMethod() {
        return this.method;
    }

    public URI getRequestUri() throws SipParseException {
        if (this.requestURI == null) {
            try {
                this.requestURI = SipURI.frame(this.requestUriBuffer);
            }
            catch (IOException e) {
                throw new SipParseException(0, "Unable to parse the request uri", e);
            }
        }
        return this.requestURI;
    }

    @Override
    public Buffer getBuffer() {
        Buffer tmp = Buffers.createBuffer((int)1024);
        this.getBytes(tmp);
        return tmp;
    }

    public String toString() {
        return this.getBuffer().toString();
    }

    @Override
    public SipRequestLine clone() {
        Buffer requestURI = this.requestUriBuffer.clone();
        return new SipRequestLine(this.method, requestURI);
    }

    @Override
    public void getBytes(Buffer dst) {
        this.method.getBytes(0, dst);
        dst.write((byte)32);
        if (this.requestURI != null) {
            this.requestURI.getBytes(dst);
        } else {
            this.requestUriBuffer.getBytes(0, dst);
        }
        dst.write((byte)32);
        SipParser.SIP2_0.getBytes(0, dst);
    }
}

