/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.SipRequest;
import io.pkts.packet.sip.address.SipURI;
import io.pkts.packet.sip.address.URI;
import io.pkts.packet.sip.header.CSeqHeader;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.ToHeader;
import io.pkts.packet.sip.impl.ImmutableSipRequest;
import io.pkts.packet.sip.impl.PreConditions;
import io.pkts.packet.sip.impl.SipInitialLine;
import io.pkts.packet.sip.impl.SipMessageBuilder;
import io.pkts.packet.sip.impl.SipRequestLine;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;

public class SipRequestBuilder
extends SipMessageBuilder<SipRequest>
implements SipRequest.Builder {
    private Buffer method;
    private URI requestURI;

    public SipRequestBuilder(Buffer method) {
        super(15);
        this.method = method;
    }

    @Override
    protected CSeqHeader generateDefaultCSeqHeader() {
        return CSeqHeader.withMethod(this.method).build();
    }

    @Override
    protected ToHeader generateDefaultToHeader() {
        PreConditions.assertNotNull(this.requestURI, "No request-uri has been specified so cannot generate a default To-header");
        if (this.requestURI.isSipURI()) {
            SipURI sipURI = this.requestURI.toSipURI();
            return (ToHeader)ToHeader.withHost(sipURI.getHost()).withUser((Buffer)sipURI.getUser().orElse(null)).build();
        }
        throw new SipParseException("Not sure how to generate a default To-header off of a " + this.requestURI.getClass());
    }

    @Override
    protected final boolean isBuildingRequest() {
        return true;
    }

    @Override
    protected SipInitialLine buildInitialLine() throws SipParseException {
        PreConditions.assertNotNull(this.requestURI, "You must specify the request URI");
        Function<SipURI, SipURI> f = this.getRequestURIFunction();
        URI finalURI = this.requestURI;
        if (finalURI.isSipURI() && f != null) {
            try {
                finalURI = f.apply(finalURI.toSipURI());
            }
            catch (Exception e) {
                throw new SipParseException(0, "Unable to construct request URI due exception from registered function", e);
            }
        }
        return new SipRequestLine(this.method, finalURI);
    }

    @Override
    protected SipRequest internalBuild(Buffer msg, SipInitialLine initialLine, List<SipHeader> headers, short indexOfTo, short indexOfFrom, short indexOfCSeq, short indexOfCallId, short indexOfMaxForwards, short indexOfVia, short indexOfRoute, short indexOfRecordRoute, short indexOfContact, Buffer body) {
        return new ImmutableSipRequest(msg, initialLine.toRequestLine(), headers, indexOfTo, indexOfFrom, indexOfCSeq, indexOfCallId, indexOfMaxForwards, indexOfVia, indexOfRoute, indexOfRecordRoute, indexOfContact, body);
    }

    @Override
    public SipRequest.Builder withRequestURI(URI uri) throws SipParseException {
        PreConditions.assertNotNull(uri, "The request URI cannot be null");
        this.requestURI = uri;
        return this;
    }

    @Override
    public SipRequest.Builder withRequestURI(String uri) throws SipParseException {
        PreConditions.assertNotEmpty(uri, "The URI cannot be empty string or null");
        try {
            this.requestURI = URI.frame(Buffers.wrap((String)uri));
        }
        catch (IOException e) {
            throw new SipParseException("Received IOException when trying to read from the Buffer");
        }
        return this;
    }
}

