/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.websocket;

import io.ktor.util.NIOKt;
import io.ktor.utils.io.core.StringsKt;
import io.ktor.websocket.CloseReason;
import io.ktor.websocket.FrameType;
import io.ktor.websocket.NonDisposableHandle;
import java.nio.ByteBuffer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.DisposableHandle;
import kotlinx.io.Buffer;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import kotlinx.io.SourcesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 (2\u00020\u0001:\u0006)*+,-(BI\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0002\u0012\b\b\u0002\u0010\f\u001a\u00020\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010\n\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u0014\u001a\u0004\b \u0010\u0016R\u0017\u0010\u000b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0014\u001a\u0004\b!\u0010\u0016R\u0017\u0010\f\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\u0014\u001a\u0004\b\"\u0010\u0016R\u0017\u0010$\u001a\u00020#8\u0006\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\u0082\u0001\u0005./012\u00a8\u00063"}, d2={"Lio/ktor/websocket/Frame;", "", "", "fin", "Lio/ktor/websocket/FrameType;", "frameType", "", "data", "Lkotlinx/coroutines/DisposableHandle;", "disposableHandle", "rsv1", "rsv2", "rsv3", "<init>", "(ZLio/ktor/websocket/FrameType;[BLkotlinx/coroutines/DisposableHandle;ZZZ)V", "", "toString", "()Ljava/lang/String;", "copy", "()Lio/ktor/websocket/Frame;", "Z", "getFin", "()Z", "Lio/ktor/websocket/FrameType;", "getFrameType", "()Lio/ktor/websocket/FrameType;", "[B", "getData", "()[B", "Lkotlinx/coroutines/DisposableHandle;", "getDisposableHandle", "()Lkotlinx/coroutines/DisposableHandle;", "getRsv1", "getRsv2", "getRsv3", "Ljava/nio/ByteBuffer;", "buffer", "Ljava/nio/ByteBuffer;", "getBuffer", "()Ljava/nio/ByteBuffer;", "Companion", "Binary", "Text", "Close", "Ping", "Pong", "Lio/ktor/websocket/Frame$Binary;", "Lio/ktor/websocket/Frame$Close;", "Lio/ktor/websocket/Frame$Ping;", "Lio/ktor/websocket/Frame$Pong;", "Lio/ktor/websocket/Frame$Text;", "ktor-websockets"})
public abstract class Frame {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean fin;
    @NotNull
    private final FrameType frameType;
    @NotNull
    private final byte[] data;
    @NotNull
    private final DisposableHandle disposableHandle;
    private final boolean rsv1;
    private final boolean rsv2;
    private final boolean rsv3;
    @NotNull
    private final ByteBuffer buffer;
    @NotNull
    private static final byte[] Empty = new byte[0];

    private Frame(boolean fin, FrameType frameType, byte[] data, DisposableHandle disposableHandle, boolean rsv1, boolean rsv2, boolean rsv3) {
        this.fin = fin;
        this.frameType = frameType;
        this.data = data;
        this.disposableHandle = disposableHandle;
        this.rsv1 = rsv1;
        this.rsv2 = rsv2;
        this.rsv3 = rsv3;
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.data);
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "wrap(...)");
        this.buffer = byteBuffer;
    }

    public /* synthetic */ Frame(boolean bl, FrameType frameType, byte[] byArray, DisposableHandle disposableHandle, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            disposableHandle = NonDisposableHandle.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            bl3 = false;
        }
        if ((n & 0x40) != 0) {
            bl4 = false;
        }
        this(bl, frameType, byArray, disposableHandle, bl2, bl3, bl4, null);
    }

    public final boolean getFin() {
        return this.fin;
    }

    @NotNull
    public final FrameType getFrameType() {
        return this.frameType;
    }

    @NotNull
    public final byte[] getData() {
        return this.data;
    }

    @NotNull
    public final DisposableHandle getDisposableHandle() {
        return this.disposableHandle;
    }

    public final boolean getRsv1() {
        return this.rsv1;
    }

    public final boolean getRsv2() {
        return this.rsv2;
    }

    public final boolean getRsv3() {
        return this.rsv3;
    }

    @NotNull
    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    @NotNull
    public String toString() {
        return "Frame " + (Object)((Object)this.frameType) + " (fin=" + this.fin + ", buffer len = " + this.data.length + ')';
    }

    @NotNull
    public final Frame copy() {
        byte[] byArray = Arrays.copyOf(this.data, this.data.length);
        Intrinsics.checkNotNullExpressionValue(byArray, "copyOf(...)");
        return Companion.byType(this.fin, this.frameType, byArray, this.rsv1, this.rsv2, this.rsv3);
    }

    public /* synthetic */ Frame(boolean fin, FrameType frameType, byte[] data, DisposableHandle disposableHandle, boolean rsv1, boolean rsv2, boolean rsv3, DefaultConstructorMarker $constructor_marker) {
        this(fin, frameType, data, disposableHandle, rsv1, rsv2, rsv3);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0002\u0012\b\b\u0002\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\t\u0010\rB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\u000eB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\t\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lio/ktor/websocket/Frame$Binary;", "Lio/ktor/websocket/Frame;", "", "fin", "", "data", "rsv1", "rsv2", "rsv3", "<init>", "(Z[BZZZ)V", "Ljava/nio/ByteBuffer;", "buffer", "(ZLjava/nio/ByteBuffer;)V", "(Z[B)V", "Lkotlinx/io/Source;", "packet", "(ZLkotlinx/io/Source;)V", "ktor-websockets"})
    public static final class Binary
    extends Frame {
        public Binary(boolean fin, @NotNull byte[] data, boolean rsv1, boolean rsv2, boolean rsv3) {
            Intrinsics.checkNotNullParameter(data, "data");
            super(fin, FrameType.BINARY, data, NonDisposableHandle.INSTANCE, rsv1, rsv2, rsv3, null);
        }

        public /* synthetic */ Binary(boolean bl, byte[] byArray, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl2 = false;
            }
            if ((n & 8) != 0) {
                bl3 = false;
            }
            if ((n & 0x10) != 0) {
                bl4 = false;
            }
            this(bl, byArray, bl2, bl3, bl4);
        }

        public Binary(boolean fin, @NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter(buffer, "buffer");
            this(fin, NIOKt.moveToByteArray(buffer));
        }

        public Binary(boolean fin, @NotNull byte[] data) {
            Intrinsics.checkNotNullParameter(data, "data");
            this(fin, data, false, false, false);
        }

        public Binary(boolean fin, @NotNull Source packet) {
            Intrinsics.checkNotNullParameter(packet, "packet");
            this(fin, SourcesKt.readByteArray(packet));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\u000bB\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0004\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lio/ktor/websocket/Frame$Close;", "Lio/ktor/websocket/Frame;", "", "data", "<init>", "([B)V", "Lio/ktor/websocket/CloseReason;", "reason", "(Lio/ktor/websocket/CloseReason;)V", "Lkotlinx/io/Source;", "packet", "(Lkotlinx/io/Source;)V", "()V", "Ljava/nio/ByteBuffer;", "buffer", "(Ljava/nio/ByteBuffer;)V", "ktor-websockets"})
    @SourceDebugExtension(value={"SMAP\nFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Frame.kt\nio/ktor/websocket/Frame$Close\n+ 2 Builder.kt\nio/ktor/utils/io/core/BuilderKt\n*L\n1#1,158:1\n15#2,3:159\n*S KotlinDebug\n*F\n+ 1 Frame.kt\nio/ktor/websocket/Frame$Close\n*L\n89#1:159,3\n*E\n"})
    public static final class Close
    extends Frame {
        public Close(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter(data, "data");
            super(true, FrameType.CLOSE, data, NonDisposableHandle.INSTANCE, false, false, false, null);
        }

        /*
         * WARNING - void declaration
         */
        public Close(@NotNull CloseReason reason) {
            void $this$_init__u24lambda_u240;
            Intrinsics.checkNotNullParameter(reason, "reason");
            boolean $i$f$buildPacket = false;
            Buffer builder$iv = new Buffer();
            Sink sink2 = builder$iv;
            Close close2 = this;
            boolean bl = false;
            $this$_init__u24lambda_u240.writeShort(reason.getCode());
            StringsKt.writeText$default((Sink)$this$_init__u24lambda_u240, reason.getMessage(), 0, 0, null, 14, null);
            close2(builder$iv);
        }

        public Close(@NotNull Source packet) {
            Intrinsics.checkNotNullParameter(packet, "packet");
            this(SourcesKt.readByteArray(packet));
        }

        public Close() {
            this(Empty);
        }

        public Close(@NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter(buffer, "buffer");
            this(NIOKt.moveToByteArray(buffer));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J=\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lio/ktor/websocket/Frame$Companion;", "", "<init>", "()V", "", "fin", "Lio/ktor/websocket/FrameType;", "frameType", "", "data", "rsv1", "rsv2", "rsv3", "Lio/ktor/websocket/Frame;", "byType", "(ZLio/ktor/websocket/FrameType;[BZZZ)Lio/ktor/websocket/Frame;", "Empty", "[B", "ktor-websockets"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Frame byType(boolean fin, @NotNull FrameType frameType, @NotNull byte[] data, boolean rsv1, boolean rsv2, boolean rsv3) {
            Frame frame;
            Intrinsics.checkNotNullParameter((Object)frameType, "frameType");
            Intrinsics.checkNotNullParameter(data, "data");
            switch (WhenMappings.$EnumSwitchMapping$0[frameType.ordinal()]) {
                case 1: {
                    frame = new Binary(fin, data, rsv1, rsv2, rsv3);
                    break;
                }
                case 2: {
                    frame = new Text(fin, data, rsv1, rsv2, rsv3);
                    break;
                }
                case 3: {
                    frame = new Close(data);
                    break;
                }
                case 4: {
                    frame = new Ping(data);
                    break;
                }
                case 5: {
                    frame = new Pong(data, (DisposableHandle)NonDisposableHandle.INSTANCE);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return frame;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[FrameType.values().length];
                try {
                    nArray[FrameType.BINARY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FrameType.TEXT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FrameType.CLOSE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FrameType.PING.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FrameType.PONG.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/ktor/websocket/Frame$Ping;", "Lio/ktor/websocket/Frame;", "", "data", "<init>", "([B)V", "Lkotlinx/io/Source;", "packet", "(Lkotlinx/io/Source;)V", "Ljava/nio/ByteBuffer;", "buffer", "(Ljava/nio/ByteBuffer;)V", "ktor-websockets"})
    public static final class Ping
    extends Frame {
        public Ping(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter(data, "data");
            super(true, FrameType.PING, data, NonDisposableHandle.INSTANCE, false, false, false, null);
        }

        public Ping(@NotNull Source packet) {
            Intrinsics.checkNotNullParameter(packet, "packet");
            this(SourcesKt.readByteArray(packet));
        }

        public Ping(@NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter(buffer, "buffer");
            this(NIOKt.moveToByteArray(buffer));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\nB\u001b\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\rB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0006\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/ktor/websocket/Frame$Pong;", "Lio/ktor/websocket/Frame;", "", "data", "Lkotlinx/coroutines/DisposableHandle;", "disposableHandle", "<init>", "([BLkotlinx/coroutines/DisposableHandle;)V", "Lkotlinx/io/Source;", "packet", "(Lkotlinx/io/Source;)V", "Ljava/nio/ByteBuffer;", "buffer", "(Ljava/nio/ByteBuffer;Lkotlinx/coroutines/DisposableHandle;)V", "(Ljava/nio/ByteBuffer;)V", "ktor-websockets"})
    public static final class Pong
    extends Frame {
        public Pong(@NotNull byte[] data, @NotNull DisposableHandle disposableHandle) {
            Intrinsics.checkNotNullParameter(data, "data");
            Intrinsics.checkNotNullParameter(disposableHandle, "disposableHandle");
            super(true, FrameType.PONG, data, disposableHandle, false, false, false, null);
        }

        public /* synthetic */ Pong(byte[] byArray, DisposableHandle disposableHandle, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                disposableHandle = NonDisposableHandle.INSTANCE;
            }
            this(byArray, disposableHandle);
        }

        public Pong(@NotNull Source packet) {
            Intrinsics.checkNotNullParameter(packet, "packet");
            this(SourcesKt.readByteArray(packet), (DisposableHandle)NonDisposableHandle.INSTANCE);
        }

        public Pong(@NotNull ByteBuffer buffer, @NotNull DisposableHandle disposableHandle) {
            Intrinsics.checkNotNullParameter(buffer, "buffer");
            Intrinsics.checkNotNullParameter(disposableHandle, "disposableHandle");
            this(NIOKt.moveToByteArray(buffer), disposableHandle);
        }

        public /* synthetic */ Pong(ByteBuffer byteBuffer, DisposableHandle disposableHandle, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                disposableHandle = NonDisposableHandle.INSTANCE;
            }
            this(byteBuffer, disposableHandle);
        }

        public Pong(@NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter(buffer, "buffer");
            this(NIOKt.moveToByteArray(buffer), (DisposableHandle)NonDisposableHandle.INSTANCE);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0002\u0012\b\b\u0002\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\u000eB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\t\u0010\u0011B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\t\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lio/ktor/websocket/Frame$Text;", "Lio/ktor/websocket/Frame;", "", "fin", "", "data", "rsv1", "rsv2", "rsv3", "<init>", "(Z[BZZZ)V", "(Z[B)V", "", "text", "(Ljava/lang/String;)V", "Lkotlinx/io/Source;", "packet", "(ZLkotlinx/io/Source;)V", "Ljava/nio/ByteBuffer;", "buffer", "(ZLjava/nio/ByteBuffer;)V", "ktor-websockets"})
    public static final class Text
    extends Frame {
        public Text(boolean fin, @NotNull byte[] data, boolean rsv1, boolean rsv2, boolean rsv3) {
            Intrinsics.checkNotNullParameter(data, "data");
            super(fin, FrameType.TEXT, data, NonDisposableHandle.INSTANCE, rsv1, rsv2, rsv3, null);
        }

        public /* synthetic */ Text(boolean bl, byte[] byArray, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl2 = false;
            }
            if ((n & 8) != 0) {
                bl3 = false;
            }
            if ((n & 0x10) != 0) {
                bl4 = false;
            }
            this(bl, byArray, bl2, bl3, bl4);
        }

        public Text(boolean fin, @NotNull byte[] data) {
            Intrinsics.checkNotNullParameter(data, "data");
            this(fin, data, false, false, false);
        }

        public Text(@NotNull String text) {
            Intrinsics.checkNotNullParameter(text, "text");
            this(true, StringsKt.toByteArray$default(text, null, 1, null));
        }

        public Text(boolean fin, @NotNull Source packet) {
            Intrinsics.checkNotNullParameter(packet, "packet");
            this(fin, SourcesKt.readByteArray(packet));
        }

        public Text(boolean fin, @NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter(buffer, "buffer");
            this(fin, NIOKt.moveToByteArray(buffer));
        }
    }
}

