/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.websocket;

import io.ktor.utils.io.charsets.EncodingKt;
import io.ktor.utils.io.core.BytePacketBuilderKt;
import io.ktor.utils.io.core.StringsKt;
import io.ktor.websocket.CloseReason;
import io.ktor.websocket.Frame;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.io.Buffer;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0011\u0010\u0006\u001a\u00020\u0005*\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0013\u0010\n\u001a\u0004\u0018\u00010\t*\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/ktor/websocket/Frame$Text;", "", "readText", "(Lio/ktor/websocket/Frame$Text;)Ljava/lang/String;", "Lio/ktor/websocket/Frame;", "", "readBytes", "(Lio/ktor/websocket/Frame;)[B", "Lio/ktor/websocket/Frame$Close;", "Lio/ktor/websocket/CloseReason;", "readReason", "(Lio/ktor/websocket/Frame$Close;)Lio/ktor/websocket/CloseReason;", "ktor-websockets"})
@SourceDebugExtension(value={"SMAP\nFrameCommon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameCommon.kt\nio/ktor/websocket/FrameCommonKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Builder.kt\nio/ktor/utils/io/core/BuilderKt\n*L\n1#1,173:1\n1#2:174\n15#3,3:175\n15#3,3:178\n*S KotlinDebug\n*F\n+ 1 FrameCommon.kt\nio/ktor/websocket/FrameCommonKt\n*L\n144#1:175,3\n162#1:178,3\n*E\n"})
public final class FrameCommonKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String readText(@NotNull Frame.Text $this$readText) {
        void $this$readText_u24lambda_u241;
        Intrinsics.checkNotNullParameter($this$readText, "<this>");
        if (!$this$readText.getFin()) {
            boolean $i$a$-require-FrameCommonKt$readText$22 = false;
            String $i$a$-require-FrameCommonKt$readText$22 = "Text could be only extracted from non-fragmented frame";
            throw new IllegalArgumentException($i$a$-require-FrameCommonKt$readText$22.toString());
        }
        CharsetDecoder charsetDecoder = Charsets.UTF_8.newDecoder();
        Intrinsics.checkNotNullExpressionValue(charsetDecoder, "newDecoder(...)");
        boolean $i$f$buildPacket = false;
        Buffer builder$iv = new Buffer();
        Sink sink2 = builder$iv;
        CharsetDecoder charsetDecoder2 = charsetDecoder;
        boolean bl = false;
        BytePacketBuilderKt.writeFully$default((Sink)$this$readText_u24lambda_u241, $this$readText.getData(), 0, 0, 6, null);
        return EncodingKt.decode$default(charsetDecoder2, builder$iv, 0, 2, null);
    }

    @NotNull
    public static final byte[] readBytes(@NotNull Frame $this$readBytes) {
        Intrinsics.checkNotNullParameter($this$readBytes, "<this>");
        byte[] byArray = $this$readBytes.getData();
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkNotNullExpressionValue(byArray2, "copyOf(...)");
        return byArray2;
    }

    @Nullable
    public static final CloseReason readReason(@NotNull Frame.Close $this$readReason) {
        Intrinsics.checkNotNullParameter($this$readReason, "<this>");
        if ($this$readReason.getData().length < 2) {
            return null;
        }
        boolean $i$f$buildPacket = false;
        Buffer builder$iv = new Buffer();
        Sink $this$readReason_u24lambda_u242 = builder$iv;
        boolean bl = false;
        BytePacketBuilderKt.writeFully$default($this$readReason_u24lambda_u242, $this$readReason.getData(), 0, 0, 6, null);
        Source packet = builder$iv;
        short code = packet.readShort();
        String message = StringsKt.readText$default(packet, null, 0, 3, null);
        return new CloseReason(code, message);
    }
}

