/*
 * Decompiled with CFR 0.152.
 */
package io.portone.sdk.server.webhook;

import io.portone.sdk.server.errors.WebhookVerificationException;
import io.portone.sdk.server.webhook.Webhook;
import io.portone.sdk.server.webhook.WebhookSerializer;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\nJ,\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\tJ\"\u0010\u0013\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/portone/sdk/server/webhook/WebhookVerifier;", "", "secretKeySpec", "Ljavax/crypto/spec/SecretKeySpec;", "<init>", "(Ljavax/crypto/spec/SecretKeySpec;)V", "secretKey", "", "([B)V", "", "(Ljava/lang/String;)V", "json", "Lkotlinx/serialization/json/Json;", "verify", "Lio/portone/sdk/server/webhook/Webhook;", "msgBody", "msgId", "msgSignature", "msgTimestamp", "sign", "timestamp", "", "payload", "Companion", "lib"})
@SourceDebugExtension(value={"SMAP\nWebhookVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebhookVerifier.kt\nio/portone/sdk/server/webhook/WebhookVerifier\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,162:1\n2163#2,2:163\n*S KotlinDebug\n*F\n+ 1 WebhookVerifier.kt\nio/portone/sdk/server/webhook/WebhookVerifier\n*L\n93#1:163,2\n*E\n"})
public final class WebhookVerifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SecretKeySpec secretKeySpec;
    @NotNull
    private final Json json;
    @NotNull
    public static final String HEADER_ID = "webhook-id";
    @NotNull
    public static final String HEADER_SIGNATURE = "webhook-signature";
    @NotNull
    public static final String HEADER_TIMESTAMP = "webhook-timestamp";
    @NotNull
    private static final String SECRET_PREFIX = "whsec_";
    @NotNull
    private static final String HMAC_SHA256 = "HmacSHA256";
    private static final int TOLERANCE_IN_SECONDS = 300;
    private static final long SECOND_IN_MS = 1000L;

    private WebhookVerifier(SecretKeySpec secretKeySpec) {
        this.secretKeySpec = secretKeySpec;
        this.json = JsonKt.Json$default(null, WebhookVerifier::json$lambda$0, 1, null);
    }

    public WebhookVerifier(@NotNull byte[] secretKey) {
        Intrinsics.checkNotNullParameter(secretKey, "secretKey");
        this(new SecretKeySpec(secretKey, HMAC_SHA256));
    }

    public WebhookVerifier(@NotNull String secretKey) {
        String string;
        Intrinsics.checkNotNullParameter(secretKey, "secretKey");
        Base64.Decoder decoder = Base64.getDecoder();
        if (StringsKt.startsWith$default(secretKey, SECRET_PREFIX, false, 2, null)) {
            String string2 = secretKey.substring(6);
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        } else {
            string = secretKey;
        }
        byte[] byArray = decoder.decode(string);
        Intrinsics.checkNotNullExpressionValue(byArray, "decode(...)");
        this(byArray);
    }

    @NotNull
    public final Webhook verify(@NotNull String msgBody, @Nullable String msgId, @Nullable String msgSignature, @Nullable String msgTimestamp) throws WebhookVerificationException {
        boolean bl;
        block10: {
            Sequence msgSignatures;
            Intrinsics.checkNotNullParameter(msgBody, "msgBody");
            if (msgId == null || msgSignature == null || msgTimestamp == null) {
                throw new WebhookVerificationException("Missing required headers", null, 2, null);
            }
            long timestamp = WebhookVerifier.Companion.verifyTimestamp(msgTimestamp);
            byte[] expectedSignature = this.sign(msgId, timestamp, msgBody);
            char[] cArray = new char[]{' '};
            Sequence $this$none$iv = msgSignatures = StringsKt.splitToSequence$default((CharSequence)msgSignature, cArray, false, 0, 6, null);
            boolean $i$f$none = false;
            Iterator iterator2 = $this$none$iv.iterator();
            while (iterator2.hasNext()) {
                boolean bl2;
                block9: {
                    Object element$iv = iterator2.next();
                    String versionedSignature = (String)element$iv;
                    boolean bl3 = false;
                    char[] cArray2 = new char[]{','};
                    List sigParts = StringsKt.split$default((CharSequence)versionedSignature, cArray2, false, 3, 2, null);
                    if (sigParts.size() < 2) {
                        bl2 = false;
                    } else {
                        String version = (String)sigParts.get(0);
                        String signatureStr = (String)sigParts.get(1);
                        if (!Intrinsics.areEqual(version, "v1")) {
                            bl2 = false;
                        } else {
                            byte[] byArray;
                            try {
                                byArray = Base64.getDecoder().decode(signatureStr);
                            }
                            catch (IllegalArgumentException e) {
                                bl2 = false;
                                break block9;
                            }
                            byte[] signature = byArray;
                            bl2 = MessageDigest.isEqual(signature, expectedSignature);
                        }
                    }
                }
                if (!bl2) continue;
                bl = false;
                break block10;
            }
            bl = true;
        }
        if (bl) {
            throw new WebhookVerificationException("No matching signature found", null, 2, null);
        }
        return (Webhook)this.json.decodeFromString(WebhookSerializer.INSTANCE, msgBody);
    }

    private final byte[] sign(String msgId, long timestamp, String payload) {
        Mac mac = Mac.getInstance(HMAC_SHA256);
        mac.init(this.secretKeySpec);
        String string = msgId + '.' + timestamp + '.' + payload;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        byte[] byArray2 = mac.doFinal(byArray);
        Intrinsics.checkNotNullExpressionValue(byArray2, "doFinal(...)");
        return byArray2;
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter($this$Json, "$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/portone/sdk/server/webhook/WebhookVerifier$Companion;", "", "<init>", "()V", "HEADER_ID", "", "HEADER_SIGNATURE", "HEADER_TIMESTAMP", "SECRET_PREFIX", "HMAC_SHA256", "TOLERANCE_IN_SECONDS", "", "SECOND_IN_MS", "", "verifyTimestamp", "msgTimestamp", "lib"})
    public static final class Companion {
        private Companion() {
        }

        private final long verifyTimestamp(String msgTimestamp) throws WebhookVerificationException {
            long now = System.currentTimeMillis() / 1000L;
            Long l = StringsKt.toLongOrNull(msgTimestamp);
            if (l == null) {
                throw new WebhookVerificationException("Invalid Signature Headers", null, 2, null);
            }
            long timestamp = l;
            if (timestamp < now - (long)300) {
                throw new WebhookVerificationException("Message timestamp too old", null, 2, null);
            }
            if (timestamp > now + (long)300) {
                throw new WebhookVerificationException("Message timestamp too new", null, 2, null);
            }
            return timestamp;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

