/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.RawSink;
import kotlinx.io.Segment;
import kotlinx.io._UtilKt;
import kotlinx.io.unsafe.UnsafeBufferOperations;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016J\b\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lkotlinx/io/OutputStreamSink;", "Lkotlinx/io/RawSink;", "out", "Ljava/io/OutputStream;", "<init>", "(Ljava/io/OutputStream;)V", "write", "", "source", "Lkotlinx/io/Buffer;", "byteCount", "", "flush", "close", "toString", "", "kotlinx-io-core"})
@SourceDebugExtension(value={"SMAP\nJvmCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmCore.kt\nkotlinx/io/OutputStreamSink\n+ 2 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperations\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 -Util.kt\nkotlinx/io/_UtilKt\n*L\n1#1,112:1\n99#2:113\n100#2,2:115\n102#2,6:118\n1#3:114\n109#4:117\n*S KotlinDebug\n*F\n+ 1 JvmCore.kt\nkotlinx/io/OutputStreamSink\n*L\n48#1:113\n48#1:115,2\n48#1:118,6\n48#1:114\n49#1:117\n*E\n"})
class OutputStreamSink
implements RawSink {
    @NotNull
    private final OutputStream out;

    public OutputStreamSink(@NotNull OutputStream out) {
        Intrinsics.checkNotNullParameter(out, "out");
        this.out = out;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(@NotNull Buffer source2, long byteCount) {
        int toCopy;
        Intrinsics.checkNotNullParameter(source2, "source");
        _UtilKt.checkOffsetAndCount(source2.getSize(), 0L, byteCount);
        long remaining = 0L;
        for (remaining = byteCount; remaining > 0L; remaining -= (long)toCopy) {
            void a$iv;
            void pos;
            void limit;
            Segment head$iv;
            UnsafeBufferOperations this_$iv = UnsafeBufferOperations.INSTANCE;
            boolean $i$f$readFromHead = false;
            if (!(!source2.exhausted())) {
                boolean $i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22 = false;
                String $i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22 = "Buffer is empty";
                throw new IllegalArgumentException($i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22.toString());
            }
            Intrinsics.checkNotNull(source2.getHead());
            int n = head$iv.getLimit();
            int n2 = head$iv.getPos();
            byte[] data = head$iv.dataAsByteArray(true);
            boolean bl = false;
            long l = remaining;
            void b$iv = limit - pos;
            boolean $i$f$minOf = false;
            toCopy = (int)Math.min((long)a$iv, (long)b$iv);
            this.out.write(data, (int)pos, toCopy);
            int bytesRead$iv = toCopy;
            if (bytesRead$iv == 0) continue;
            if (bytesRead$iv < 0) {
                throw new IllegalStateException("Returned negative read bytes count");
            }
            if (bytesRead$iv > head$iv.getSize()) {
                throw new IllegalStateException("Returned too many bytes");
            }
            source2.skip(bytesRead$iv);
        }
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void close() {
        this.out.close();
    }

    @NotNull
    public String toString() {
        return "RawSink(" + this.out + ')';
    }
}

