/*
 * Decompiled with CFR 0.152.
 */
package io.portone.sdk.server.common;

import io.portone.sdk.server.common.Bank;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lio/portone/sdk/server/common/BankSerializer;", "Lkotlinx/serialization/KSerializer;", "Lio/portone/sdk/server/common/Bank;", "<init>", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "lib"})
final class BankSerializer
implements KSerializer<Bank> {
    @NotNull
    public static final BankSerializer INSTANCE = new BankSerializer();
    @NotNull
    private static final SerialDescriptor descriptor;

    private BankSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @NotNull
    public Bank deserialize(@NotNull Decoder decoder) {
        Bank bank;
        String value;
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        switch (value = decoder.decodeString()) {
            case "BANK_OF_KOREA": {
                bank = Bank.BankOfKorea.INSTANCE;
                break;
            }
            case "KDB": {
                bank = Bank.Kdb.INSTANCE;
                break;
            }
            case "IBK": {
                bank = Bank.Ibk.INSTANCE;
                break;
            }
            case "KOOKMIN": {
                bank = Bank.Kookmin.INSTANCE;
                break;
            }
            case "SUHYUP": {
                bank = Bank.Suhyup.INSTANCE;
                break;
            }
            case "KEXIM": {
                bank = Bank.Kexim.INSTANCE;
                break;
            }
            case "NONGHYUP": {
                bank = Bank.Nonghyup.INSTANCE;
                break;
            }
            case "LOCAL_NONGHYUP": {
                bank = Bank.LocalNonghyup.INSTANCE;
                break;
            }
            case "WOORI": {
                bank = Bank.Woori.INSTANCE;
                break;
            }
            case "STANDARD_CHARTERED": {
                bank = Bank.StandardChartered.INSTANCE;
                break;
            }
            case "CITI": {
                bank = Bank.Citi.INSTANCE;
                break;
            }
            case "DAEGU": {
                bank = Bank.Daegu.INSTANCE;
                break;
            }
            case "BUSAN": {
                bank = Bank.Busan.INSTANCE;
                break;
            }
            case "KWANGJU": {
                bank = Bank.Kwangju.INSTANCE;
                break;
            }
            case "JEJU": {
                bank = Bank.Jeju.INSTANCE;
                break;
            }
            case "JEONBUK": {
                bank = Bank.Jeonbuk.INSTANCE;
                break;
            }
            case "KYONGNAM": {
                bank = Bank.Kyongnam.INSTANCE;
                break;
            }
            case "KFCC": {
                bank = Bank.Kfcc.INSTANCE;
                break;
            }
            case "SHINHYUP": {
                bank = Bank.Shinhyup.INSTANCE;
                break;
            }
            case "SAVINGS_BANK": {
                bank = Bank.SavingsBank.INSTANCE;
                break;
            }
            case "MORGAN_STANLEY": {
                bank = Bank.MorganStanley.INSTANCE;
                break;
            }
            case "HSBC": {
                bank = Bank.Hsbc.INSTANCE;
                break;
            }
            case "DEUTSCHE": {
                bank = Bank.Deutsche.INSTANCE;
                break;
            }
            case "JPMC": {
                bank = Bank.Jpmc.INSTANCE;
                break;
            }
            case "MIZUHO": {
                bank = Bank.Mizuho.INSTANCE;
                break;
            }
            case "MUFG": {
                bank = Bank.Mufg.INSTANCE;
                break;
            }
            case "BANK_OF_AMERICA": {
                bank = Bank.BankOfAmerica.INSTANCE;
                break;
            }
            case "BNP_PARIBAS": {
                bank = Bank.BnpParibas.INSTANCE;
                break;
            }
            case "ICBC": {
                bank = Bank.Icbc.INSTANCE;
                break;
            }
            case "BANK_OF_CHINA": {
                bank = Bank.BankOfChina.INSTANCE;
                break;
            }
            case "NFCF": {
                bank = Bank.Nfcf.INSTANCE;
                break;
            }
            case "UOB": {
                bank = Bank.Uob.INSTANCE;
                break;
            }
            case "BOCOM": {
                bank = Bank.Bocom.INSTANCE;
                break;
            }
            case "CCB": {
                bank = Bank.Ccb.INSTANCE;
                break;
            }
            case "POST": {
                bank = Bank.Post.INSTANCE;
                break;
            }
            case "KODIT": {
                bank = Bank.Kodit.INSTANCE;
                break;
            }
            case "KIBO": {
                bank = Bank.Kibo.INSTANCE;
                break;
            }
            case "HANA": {
                bank = Bank.Hana.INSTANCE;
                break;
            }
            case "SHINHAN": {
                bank = Bank.Shinhan.INSTANCE;
                break;
            }
            case "K_BANK": {
                bank = Bank.KBank.INSTANCE;
                break;
            }
            case "KAKAO": {
                bank = Bank.Kakao.INSTANCE;
                break;
            }
            case "TOSS": {
                bank = Bank.Toss.INSTANCE;
                break;
            }
            case "MISC_FOREIGN": {
                bank = Bank.MiscForeign.INSTANCE;
                break;
            }
            case "SGI": {
                bank = Bank.Sgi.INSTANCE;
                break;
            }
            case "KCIS": {
                bank = Bank.Kcis.INSTANCE;
                break;
            }
            case "YUANTA_SECURITIES": {
                bank = Bank.YuantaSecurities.INSTANCE;
                break;
            }
            case "KB_SECURITIES": {
                bank = Bank.KbSecurities.INSTANCE;
                break;
            }
            case "SANGSANGIN_SECURITIES": {
                bank = Bank.SangsanginSecurities.INSTANCE;
                break;
            }
            case "HANYANG_SECURITIES": {
                bank = Bank.HanyangSecurities.INSTANCE;
                break;
            }
            case "LEADING_SECURITIES": {
                bank = Bank.LeadingSecurities.INSTANCE;
                break;
            }
            case "BNK_SECURITIES": {
                bank = Bank.BnkSecurities.INSTANCE;
                break;
            }
            case "IBK_SECURITIES": {
                bank = Bank.IbkSecurities.INSTANCE;
                break;
            }
            case "DAOL_SECURITIES": {
                bank = Bank.DaolSecurities.INSTANCE;
                break;
            }
            case "MIRAE_ASSET_SECURITIES": {
                bank = Bank.MiraeAssetSecurities.INSTANCE;
                break;
            }
            case "SAMSUNG_SECURITIES": {
                bank = Bank.SamsungSecurities.INSTANCE;
                break;
            }
            case "KOREA_SECURITIES": {
                bank = Bank.KoreaSecurities.INSTANCE;
                break;
            }
            case "NH_SECURITIES": {
                bank = Bank.NhSecurities.INSTANCE;
                break;
            }
            case "KYOBO_SECURITIES": {
                bank = Bank.KyoboSecurities.INSTANCE;
                break;
            }
            case "HI_SECURITIES": {
                bank = Bank.HiSecurities.INSTANCE;
                break;
            }
            case "HYUNDAI_MOTOR_SECURITIES": {
                bank = Bank.HyundaiMotorSecurities.INSTANCE;
                break;
            }
            case "KIWOOM_SECURITIES": {
                bank = Bank.KiwoomSecurities.INSTANCE;
                break;
            }
            case "EBEST_SECURITIES": {
                bank = Bank.EbestSecurities.INSTANCE;
                break;
            }
            case "SK_SECURITIES": {
                bank = Bank.SkSecurities.INSTANCE;
                break;
            }
            case "DAISHIN_SECURITIES": {
                bank = Bank.DaishinSecurities.INSTANCE;
                break;
            }
            case "HANHWA_SECURITIES": {
                bank = Bank.HanhwaSecurities.INSTANCE;
                break;
            }
            case "HANA_SECURITIES": {
                bank = Bank.HanaSecurities.INSTANCE;
                break;
            }
            case "TOSS_SECURITIES": {
                bank = Bank.TossSecurities.INSTANCE;
                break;
            }
            case "SHINHAN_SECURITIES": {
                bank = Bank.ShinhanSecurities.INSTANCE;
                break;
            }
            case "DB_SECURITIES": {
                bank = Bank.DbSecurities.INSTANCE;
                break;
            }
            case "EUGENE_SECURITIES": {
                bank = Bank.EugeneSecurities.INSTANCE;
                break;
            }
            case "MERITZ_SECURITIES": {
                bank = Bank.MeritzSecurities.INSTANCE;
                break;
            }
            case "KAKAO_PAY_SECURITIES": {
                bank = Bank.KakaoPaySecurities.INSTANCE;
                break;
            }
            case "BOOKOOK_SECURITIES": {
                bank = Bank.BookookSecurities.INSTANCE;
                break;
            }
            case "SHINYOUNG_SECURITIES": {
                bank = Bank.ShinyoungSecurities.INSTANCE;
                break;
            }
            case "CAPE_SECURITIES": {
                bank = Bank.CapeSecurities.INSTANCE;
                break;
            }
            case "KOREA_SECURITIES_FINANCE": {
                bank = Bank.KoreaSecuritiesFinance.INSTANCE;
                break;
            }
            case "KOREA_FOSS_SECURITIES": {
                bank = Bank.KoreaFossSecurities.INSTANCE;
                break;
            }
            case "WOORI_INVESTMENT_BANK": {
                bank = Bank.WooriInvestmentBank.INSTANCE;
                break;
            }
            default: {
                bank = new Bank.Unrecognized(value);
            }
        }
        return bank;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull Bank value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        encoder.encodeString(value.getValue());
    }

    static {
        String string = Bank.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor((String)string, (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));
    }
}

