/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.storage.extendeds3;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ConfigBuilder;
import io.pravega.common.util.ConfigurationException;
import io.pravega.common.util.Property;
import io.pravega.common.util.TypedProperties;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedS3StorageConfig {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(ExtendedS3StorageConfig.class);
    public static final Property<String> ROOT = Property.named((String)"root", (Object)"/");
    public static final Property<String> ACCESS_KEY_ID = Property.named((String)"accessKey", (Object)"");
    public static final Property<String> SECRET_KEY = Property.named((String)"secretKey", (Object)"");
    public static final Property<String> URI = Property.named((String)"url", (Object)"");
    public static final Property<String> BUCKET = Property.named((String)"bucket", (Object)"");
    public static final Property<String> NAMESPACE = Property.named((String)"namespace", (Object)"");
    public static final Property<Boolean> USENONEMATCH = Property.named((String)"useNoneMatch", (Object)false);
    private static final String COMPONENT_CODE = "extendeds3";
    private final String root;
    private final String accessKey;
    private final String secretKey;
    private final URI url;
    private final String bucket;
    private final String namespace;
    private final boolean useNoneMatch;

    private ExtendedS3StorageConfig(TypedProperties properties) throws ConfigurationException {
        this.root = properties.get(ROOT);
        this.accessKey = properties.get(ACCESS_KEY_ID);
        this.secretKey = properties.get(SECRET_KEY);
        this.url = java.net.URI.create(properties.get(URI));
        this.bucket = properties.get(BUCKET);
        this.namespace = properties.get(NAMESPACE);
        this.useNoneMatch = properties.getBoolean(USENONEMATCH);
    }

    public static ConfigBuilder<ExtendedS3StorageConfig> builder() {
        return new ConfigBuilder(COMPONENT_CODE, ExtendedS3StorageConfig::new);
    }

    @SuppressFBWarnings(justification="generated code")
    public String getRoot() {
        return this.root;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getAccessKey() {
        return this.accessKey;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getSecretKey() {
        return this.secretKey;
    }

    @SuppressFBWarnings(justification="generated code")
    public URI getUrl() {
        return this.url;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getBucket() {
        return this.bucket;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getNamespace() {
        return this.namespace;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isUseNoneMatch() {
        return this.useNoneMatch;
    }
}

